// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: float-operations.desc,v $
//  Revision 1.11.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.11.1.1  1994/12/28  18:05:25  thoth
//  image operations are now friendly with FBI.
//  image ops now use operations table
//  new sgn() function.

//  Revision 1.11  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.10  1994/10/14  20:43:19  thoth
//  The inline is much more useful in the header file.

//  Revision 1.9  1994/09/16  14:59:10  thoth
//  add fabs(image)

//  Revision 1.8  1994/07/08  16:14:11  thoth
//  fixed problems caused by returning floats instead of doubles.

//  Revision 1.7  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Float operations for the Float Discrete Image
#include "FloatDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction sum zero=0 subop=operator+ float I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_float_float_sum
#define REDUCE_float_float_sum
IA_UnaryOperationsTable<float,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_sum_tbl;

void IA_fill_Image_IP_float_float_sum_tbl();
#endif // REDUCE_float_float_sum


float sum ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_sum_tbl)
	IA_fill_Image_IP_float_float_sum_tbl();

    float(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_sum_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_float_float_sum
#define vec_reduce_float_float_sum
static float
vec_reduce_sum(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const float *ls = lhs->vec;

    float	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval + (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_float_float_sum

#ifndef scalar_reduce_float_float_sum
#define scalar_reduce_float_float_sum
static float
scalar_reduce_sum(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    float	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval + lhs->value;

    return rval;
}
#endif // scalar_reduce_float_float_sum

// scalar-scalar operation is trivial

#ifndef iter_reduce_float_float_sum
#define iter_reduce_float_float_sum
static float
iter_reduce_sum(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const unsigned sz = lhs.domain().card();

    float ltmp;
    IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    float	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval + ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_float_float_sum

#ifndef FILL_REDUCE_float_float_sum
#define FILL_REDUCE_float_float_sum
void IA_fill_Image_IP_float_float_sum_tbl()
{
    if (IA_Image_IP_float_float_sum_tbl)
	return;

    IA_UnaryOperationsTable<float,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_reduce_sum;

    IA_Image_IP_float_float_sum_tbl = new IA_UnaryOperationsTable<float,
	IA_BaseImage<IA_Point<int>, float> >(iter_reduce_sum);
    IA_Image_IP_float_float_sum_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_reduce_sum);
    IA_Image_IP_float_float_sum_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_reduce_sum);

}
#endif // REDUCE_float_float_sum

#if 0

static float vec_reduce_sum(const IA_VectorI<IA_Point<int>, float> *arg)
{
    const float *ls = arg->vec;

    float	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) +  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_float_float_sum
#define const_reduce_float_float_sum
static float const_reduce_sum(unsigned sz, float arg)
{
    float	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) + arg);
    }
    return rval;
}
#endif

static float iter_reduce_sum(const IA_Image<IA_Point<int>, float> &arg)
{
    IA_IVIter<IA_Point<int>, float>	iter(arg);

    float	temp;
    iter(temp);

    float	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) +  temp);
    }

    return rval;
}

float sum ( const IA_Image<IA_Point<int>, float> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 0 );
    IA_Image<IA_Point<int>, float>	arg(arg_);

    IA_BaseImage<IA_Point<int>, float>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, float>::s_type()) {
	return vec_reduce_sum((IA_VectorI<IA_Point<int>, float> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, float>::s_type()) {
	return const_reduce_sum
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, float> *)bip)->value);
    } else {
	return iter_reduce_sum(arg);
    }
}

#endif

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction product zero=1 subop=operator* float I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_op_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:15:43  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:05:07  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:49:00  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:23:45  thoth
// const_reduce can be overridden in the including file.
// 
// Revision 1.1  93/03/10  13:49:34  thoth
// Initial revision
// 

#ifndef REDUCE_float_float_product
#define REDUCE_float_float_product
IA_UnaryOperationsTable<float,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_float_float_product_tbl;

void IA_fill_Image_IP_float_float_product_tbl();
#endif // REDUCE_float_float_product


float product ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_float_float_product_tbl)
	IA_fill_Image_IP_float_float_product_tbl();

    float(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_float_float_product_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_float_float_product
#define vec_reduce_float_float_product
static float
vec_reduce_product(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const float *ls = lhs->vec;

    float	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = rval * (*(ls++));
    }

    return rval;
}
#endif // vec_reduce_float_float_product

#ifndef scalar_reduce_float_float_product
#define scalar_reduce_float_float_product
static float
scalar_reduce_product(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    float	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = rval * lhs->value;

    return rval;
}
#endif // scalar_reduce_float_float_product

// scalar-scalar operation is trivial

#ifndef iter_reduce_float_float_product
#define iter_reduce_float_float_product
static float
iter_reduce_product(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const unsigned sz = lhs.domain().card();

    float ltmp;
    IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    float	rval=ltmp;

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = rval * ltmp;
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_float_float_product

#ifndef FILL_REDUCE_float_float_product
#define FILL_REDUCE_float_float_product
void IA_fill_Image_IP_float_float_product_tbl()
{
    if (IA_Image_IP_float_float_product_tbl)
	return;

    IA_UnaryOperationsTable<float,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_reduce_product;

    IA_Image_IP_float_float_product_tbl = new IA_UnaryOperationsTable<float,
	IA_BaseImage<IA_Point<int>, float> >(iter_reduce_product);
    IA_Image_IP_float_float_product_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_reduce_product);
    IA_Image_IP_float_float_product_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_reduce_product);

}
#endif // REDUCE_float_float_product

#if 0

static float vec_reduce_product(const IA_VectorI<IA_Point<int>, float> *arg)
{
    const float *ls = arg->vec;

    float	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) *  (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_float_float_product
#define const_reduce_float_float_product
static float const_reduce_product(unsigned sz, float arg)
{
    float	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = ( (rval) * arg);
    }
    return rval;
}
#endif

static float iter_reduce_product(const IA_Image<IA_Point<int>, float> &arg)
{
    IA_IVIter<IA_Point<int>, float>	iter(arg);

    float	temp;
    iter(temp);

    float	rval=temp;

    while(iter(temp)) {
	rval = ( (rval) *  temp);
    }

    return rval;
}

float product ( const IA_Image<IA_Point<int>, float> &arg_)
{
    if (arg_.domain().card()==0)
	return ( 1 );
    IA_Image<IA_Point<int>, float>	arg(arg_);

    IA_BaseImage<IA_Point<int>, float>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, float>::s_type()) {
	return vec_reduce_product((IA_VectorI<IA_Point<int>, float> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, float>::s_type()) {
	return const_reduce_product
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, float> *)bip)->value);
    } else {
	return iter_reduce_product(arg);
    }
}

#endif

inline double max(double a, double b)
{
    return (a<b)?b:a;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction max zero=infinity() subop=max double I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_fn_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:04:51  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

#ifndef REDUCE_double_float_max
#define REDUCE_double_float_max
IA_UnaryOperationsTable<double,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_double_float_max_tbl;

void IA_fill_Image_IP_double_float_max_tbl();
#endif // REDUCE_double_float_max


double max ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_double_float_max_tbl)
	IA_fill_Image_IP_double_float_max_tbl();

    double(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_double_float_max_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_double_float_max
#define vec_reduce_double_float_max
static double
vec_reduce_max(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const float *ls = lhs->vec;

    double	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}
#endif // vec_reduce_double_float_max

#ifndef scalar_reduce_double_float_max
#define scalar_reduce_double_float_max
static double
scalar_reduce_max(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    double	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = max( rval, lhs->value );

    return rval;
}
#endif // scalar_reduce_double_float_max

// scalar-scalar operation is trivial

#ifndef iter_reduce_double_float_max
#define iter_reduce_double_float_max
static double
iter_reduce_max(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const unsigned sz = lhs.domain().card();

    float ltmp;
    IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    double	rval=ltmp;
    

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = max(rval, ltmp);
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_double_float_max

#ifndef FILL_REDUCE_double_float_max
#define FILL_REDUCE_double_float_max
void IA_fill_Image_IP_double_float_max_tbl()
{
    if (IA_Image_IP_double_float_max_tbl)
	return;

    IA_UnaryOperationsTable<double,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_reduce_max;

    IA_Image_IP_double_float_max_tbl = new IA_UnaryOperationsTable<double,
	IA_BaseImage<IA_Point<int>, float> >(iter_reduce_max);
    IA_Image_IP_double_float_max_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_reduce_max);
    IA_Image_IP_double_float_max_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_reduce_max);

}
#endif // REDUCE_double_float_max

#if 0

static double vec_reduce_max(const IA_VectorI<IA_Point<int>, float> *arg)
{
    const float *ls = arg->vec;

    double	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = max( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_double_float_max
#define const_reduce_double_float_max
static double const_reduce_max(unsigned sz, float arg)
{
    double	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = max(rval, arg);
    }
    return rval;
}
#endif

static double iter_reduce_max(const IA_Image<IA_Point<int>, float> &arg)
{
    IA_IVIter<IA_Point<int>, float>	iter(arg);

    float	temp;
    iter(temp);

    double	rval=temp;

    while(iter(temp)) {
	rval = max(rval, temp);
    }

    return rval;
}

double max ( const IA_Image<IA_Point<int>, float> &arg_)
{
    if (arg_.domain().card()==0)
	return ( infinity() );
    IA_Image<IA_Point<int>, float>	arg(arg_);

    IA_BaseImage<IA_Point<int>, float>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, float>::s_type()) {
	return vec_reduce_max((IA_VectorI<IA_Point<int>, float> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, float>::s_type()) {
	return const_reduce_max
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, float> *)bip)->value);
    } else {
	return iter_reduce_max(arg);
    }
}
#endif

inline double min(double a, double b)
{
    return (a<b)?a:b;
}
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// reduction min zero=-infinity() subop=min double I(float)
//
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: reduce_fn_nz,v $
// Revision 1.4.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.1  1994/12/28  18:19:22  thoth
// Image operations are now friendly with FBI
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.2  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.1  1993/09/15  13:04:51  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:49:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/10  13:49:13  thoth
// Initial revision
// 

#ifndef REDUCE_double_float_min
#define REDUCE_double_float_min
IA_UnaryOperationsTable<double,
	IA_BaseImage<IA_Point<int>, float> >
	*IA_Image_IP_double_float_min_tbl;

void IA_fill_Image_IP_double_float_min_tbl();
#endif // REDUCE_double_float_min


double min ( const IA_Image<IA_Point<int>, float> &arg)
{
    if (!IA_Image_IP_double_float_min_tbl)
	IA_fill_Image_IP_double_float_min_tbl();

    double(*f)
	(IA_BaseImage<IA_Point<int>, float> &);
    f = IA_Image_IP_double_float_min_tbl->lookup_operation (arg.type());

    
    IA_BaseImage<IA_Point<int>, float>	&bip =
	*IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);

    return f(bip);
}

#ifndef vec_reduce_double_float_min
#define vec_reduce_double_float_min
static double
vec_reduce_min(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_VectorI<IA_Point<int>, float> *lhs =
	(IA_VectorI<IA_Point<int>, float> *) &lhs_;

    const float *ls = lhs->vec;

    double	rval=*(ls++);

    const unsigned sz = lhs->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}
#endif // vec_reduce_double_float_min

#ifndef scalar_reduce_double_float_min
#define scalar_reduce_double_float_min
static double
scalar_reduce_min(IA_BaseImage<IA_Point<int>, float> &lhs_)
{
    const IA_ConstI<IA_Point<int>, float> *lhs =
	(IA_ConstI<IA_Point<int>, float> *) &lhs_;

    double	rval = lhs->value;
    const unsigned sz = lhs->domain().card();

    for (unsigned i=1; i<sz; i++)
	rval = min( rval, lhs->value );

    return rval;
}
#endif // scalar_reduce_double_float_min

// scalar-scalar operation is trivial

#ifndef iter_reduce_double_float_min
#define iter_reduce_double_float_min
static double
iter_reduce_min(IA_BaseImage<IA_Point<int>, float> &lhs)
{
    const unsigned sz = lhs.domain().card();

    float ltmp;
    IA_BaseIVIter<IA_Point<int>, float>	*liter = lhs.value_iterator();

    liter->next(ltmp);
    double	rval=ltmp;
    

    for (unsigned i=1; i<sz; i++) {
	liter->next(ltmp);
	rval = min(rval, ltmp);
    }
    delete liter;

    return rval;
}
#endif // iter_reduce_double_float_min

#ifndef FILL_REDUCE_double_float_min
#define FILL_REDUCE_double_float_min
void IA_fill_Image_IP_double_float_min_tbl()
{
    if (IA_Image_IP_double_float_min_tbl)
	return;

    IA_UnaryOperationsTable<double,
	IA_BaseImage<IA_Point<int>, float> >::function f;
    f = iter_reduce_min;

    IA_Image_IP_double_float_min_tbl = new IA_UnaryOperationsTable<double,
	IA_BaseImage<IA_Point<int>, float> >(iter_reduce_min);
    IA_Image_IP_double_float_min_tbl->add_operation
	(IA_VectorI<IA_Point<int>, float>::s_type(),
	 vec_reduce_min);
    IA_Image_IP_double_float_min_tbl->add_operation
	(IA_ConstI<IA_Point<int>, float>::s_type(),
	 scalar_reduce_min);

}
#endif // REDUCE_double_float_min

#if 0

static double vec_reduce_min(const IA_VectorI<IA_Point<int>, float> *arg)
{
    const float *ls = arg->vec;

    double	rval=*(ls++);

    const unsigned sz = arg->domain().card();
    for (unsigned i=1; i<sz; i++) {
	rval = min( rval, (*(ls++)));
    }

    return rval;
}

#ifndef const_reduce_double_float_min
#define const_reduce_double_float_min
static double const_reduce_min(unsigned sz, float arg)
{
    double	rval=arg;
    for (unsigned i=1; i<sz; i++) {
	rval = min(rval, arg);
    }
    return rval;
}
#endif

static double iter_reduce_min(const IA_Image<IA_Point<int>, float> &arg)
{
    IA_IVIter<IA_Point<int>, float>	iter(arg);

    float	temp;
    iter(temp);

    double	rval=temp;

    while(iter(temp)) {
	rval = min(rval, temp);
    }

    return rval;
}

double min ( const IA_Image<IA_Point<int>, float> &arg_)
{
    if (arg_.domain().card()==0)
	return ( -infinity() );
    IA_Image<IA_Point<int>, float>	arg(arg_);

    IA_BaseImage<IA_Point<int>, float>	*bip =
	IA_FBI<IA_Point<int>,IA_Point<int>,float,float,float>
	    ::extract_baseptr(arg);
    if (arg.type() == IA_VectorI<IA_Point<int>, float>::s_type()) {
	return vec_reduce_min((IA_VectorI<IA_Point<int>, float> *)bip);
    } else if (arg.type() == IA_ConstI<IA_Point<int>, float>::s_type()) {
	return const_reduce_min
	    (arg.domain().card(),
	     ((IA_ConstI<IA_Point<int>, float> *)bip)->value);
    } else {
	return iter_reduce_min(arg);
    }
}
#endif

