// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// It's the Friendly Basepointer Inspector class!
//

//
// $Log: FBI.h,v $
// Revision 1.5.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.5.1.1  1995/01/09  18:14:26  thoth
// Support for making image operations friends.
//
// Revision 1.5  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/04/15  13:16:01  thoth
// adjustments to add new generics and rearrange arguments.
//
// Revision 1.2  1994/03/30  13:53:09  thoth
// FBI now has enough class parameters to describe friendliness of
// certain function templates.
// FBI functions are now inlines removing the need for ptrepository
// objects.
//
// Revision 1.1  1994/03/22  16:08:28  thoth
// Initial revision
//

#ifndef IA_FBI_h_
#define IA_FBI_h_

#include "Bit.h"
#include <complex.h>
#include "RGB.h"
#include "IntPoint.h"
#include "Set.h"

#if 0
template <class P,class T> class IA_BaseImage;
template <class P,class T> class IA_Image;
#else
#include "Image.h"
#endif

#if 0
template <class I> class IA_BaseDT;
template <class I> class IA_DDTemplate;
#else
#include "DDTempl.h"
#endif

#if 0
template <class P, class Q> class IA_Neighborhood;
template <class P, class Q> class IA_BaseNbh;
#else
#include "Nbh.h"
#endif

template <class P, class Q, class R, class S, class T>
class IA_FBI {
private:
    static IA_BaseImage<P,T> * extract_baseptr(const IA_Image<P,T>&i) {
	return i.bip;
    }
    static IA_Image<P,T> make_Image(IA_BaseImage<P,T> *p) {
	return IA_Image<P,T>(p);
    }

    static IA_BaseDT<IA_Image<P,T> > * extract_baseptr
	(const IA_DDTemplate<IA_Image<P,T> >&t) {
	    return t.bdtp;
	}
    static IA_DDTemplate<IA_Image<P,T> > make_DT
	(IA_BaseDT<IA_Image<P,T> > *p) {
	    return p;
	}

    static IA_BaseNbh<P,Q> *extract_baseptr(const IA_Neighborhood<P,Q>&nbh) {
	return nbh.bnbh;
    }
public:

#include "AllConv.h"
#include "AllImgOps.h"

    IA_Image<IA_Point<int>, R>
	generic_product (const IA_Image<IA_Point<int>, S> &img,
			 const IA_DDTemplate< IA_Image<IA_Point<int>, T> > &,
			 const IA_Set<IA_Point<int> > &dest_ps,
			 R (*circle)(S,T),
			 R (*gamma)(R,R),
			 R gamma_zero,
			 S ring_zero,
			 const T*);

#if 1
    friend IA_Image<IA_Point<int>, T> neighborhood_reduction
	(const IA_Image<IA_Point<int>, T> &img,
	 const IA_Neighborhood<IA_Point<int>,IA_Point<int> > &nbh,
	 const IA_Set<IA_Point<int> > &dst,
	 T (*gamma)(T, T),
	 T gamma_zero);

    friend IA_Image<IA_Point<int>, S> neighborhood_reduction
	(const IA_Image<IA_Point<int>, T> &img,
	 const IA_Neighborhood<IA_Point<int>,IA_Point<int> > &nbh,
	 const IA_Set<IA_Point<int> > &dst,
	 T gamma_zero,
	 S (*Gamma)(T*, unsigned count),
	 const S*);

    friend IA_Image<IA_Point<int>, S> neighborhood_reduction
	(const IA_Image<IA_Point<int>, T> &img,
	 const IA_Neighborhood<IA_Point<int>,IA_Point<int> > &nbh,
	 const IA_Set<IA_Point<int> > &dst,
	 S (*Gamma)(T*, unsigned count),
	 const S*);

    friend IA_Image<IA_Point<int>, T> neighborhood_reduction
	(const IA_Neighborhood<IA_Point<int>,IA_Point<int> > &nbh,
	 const IA_Image<IA_Point<int>, T> &img,
	 const IA_Set<IA_Point<int> > &dst,
	 T (*gamma)(T, T),
	 T gamma_zero);

    friend IA_Image<IA_Point<int>, S> neighborhood_reduction
	(const IA_Neighborhood<IA_Point<int>,IA_Point<int> > &nbh,
	 const IA_Image<IA_Point<int>, T> &img,
	 const IA_Set<IA_Point<int> > &dst,
	 T gamma_zero,
	 S (*Gamma)(T*, unsigned count),
	 const S*);

    friend IA_Image<IA_Point<int>, S> neighborhood_reduction
	(const IA_Neighborhood<IA_Point<int>,IA_Point<int> > &nbh,
	 const IA_Image<IA_Point<int>, T> &img,
	 const IA_Set<IA_Point<int> > &dst,
	 S (*Gamma)(T*, unsigned count),
	 const S*);
#endif
};

#if 0
#if 1
#include "BitConv.h"
#include "UcharConv.h"
#include "IntConv.h"
#include "FloatConv.h"
#include "CplxConv.h"
#else
// the Crufty Interface Anchor class.
// Gets around problems with inline friend declarations inside
// template classes
class IA_CIA {
#include "BitConv.h"
#include "UcharConv.h"
#include "IntConv.h"
#include "FloatConv.h"
#include "CplxConv.h"
};
#endif
#endif

#endif IA_FBI_h_
