// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ErrorDT.h,v $
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/22  16:08:28  thoth
// Initial revision
//

#ifndef ErrorDT_h_
#define ErrorDT_h_

#include "BaseDT.h"
#include "image_errors.h"

template <class I>
class IA_ErrorDT: public IA_BaseDT<I> {
  private:
    static char dummy;

  public:
    IA_ErrorDT()
    :IA_BaseDT<I>(IA_Set<IA_Point<int> >()) {}

    int extensive() const { return 0; }

    I operator()(const IA_Point<int> &) const {
	ia_throw( Template_Uninitialized_Exception(__FILE__, __LINE__) );
	return I();
    }
    ostream &print_this(ostream &o) const {
	ia_throw( Template_Uninitialized_Exception(__FILE__, __LINE__) );
	return o;
    }

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
    int is_a(IA::Type t) { return t == s_type() ; }

    IA_BaseDT<I> *restricted_to(const IA_Set<IA_Point<int> > &) const {
	ia_throw( Template_Uninitialized_Exception(__FILE__, __LINE__) );
	return 0;
    }
};

template <class I>
char IA_ErrorDT<I>::dummy;

#endif
