//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: cplx-conv.desc,v $
// Revision 1.3  1994/03/30  14:00:07  thoth
// Added a template-template convolution and fixed the order of arguments
// to one of the template-image convolutions.
//
// Revision 1.2  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.1  1993/11/29  22:25:25  thoth
// Initial revision
//
// 
// convolution linear_product T(complex) T(complex) T(complex)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: templ-templ-product,v $
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/29  21:06:48  jnw
// Initial revision
//


#if 0

#include "LazyInvConv.h"

#else
#ifdef UNKNOWN_IA_lazy_linear_product_complex

#error Uhoh, template-template convolutions must be declared before their image-template brothers

#endif

#ifndef KNOWN_IA_lazy_linear_product_complex
#define KNOWN_IA_lazy_linear_product_complex

struct IA_lazy_inv_linear_product_complex : public IA_InvariantDT< IA_Image<IA_Point<int>,complex> > {
  private:
    static char dummy;

public:
    /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> >	lhs, rhs;

public:
    IA_lazy_inv_linear_product_complex(const IA_Set<IA_Point<int> > &ps,
		     const /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> > &lhs_,
		     const /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> > &rhs_)
	: IA_InvariantDT< IA_Image<IA_Point<int>,complex> >(ps, linear_product(lhs_(extend_to_point(0,ps.dim())),
					    rhs_,
					    lhs_(extend_to_point(0,ps.dim())).domain() + rhs_(extend_to_point(0,ps.dim())).domain())),
    lhs(lhs_), rhs(rhs_) {
    }

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
    int is_a(IA::Type t) {
	 int rval;
	rval = (t == s_type());
	rval = rval || t == IA_InvariantDT< IA_Image<IA_Point<int>,complex> >::s_type();
	return rval; }
};

char IA_lazy_inv_linear_product_complex :: dummy;

#endif // KNOWN_IA_lazy_linear_product_complex

#endif

/*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> >
linear_product(const IA_DDTemplate< IA_Image<IA_Point<int>,complex> > &lhs_,
     const IA_DDTemplate< IA_Image<IA_Point<int>,complex> > &rhs_)
{
    /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> > lhs(lhs_);
    /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> > rhs(rhs_);
    if (lhs.type() == IA_InvariantDT< IA_Image<IA_Point<int>,complex> >::s_type() &&
	rhs.type() == IA_InvariantDT< IA_Image<IA_Point<int>,complex> >::s_type()) {
#if 0
	return /*PROMOTE*/IA_DDTemplate< IA_Image<IA_Point<int>,complex> >
	    (new IA_lazy_inv_linear_product_complex (lhs.domain(), lhs, rhs ));
#else
	return IA_FBI<IA_Point<int>, IA_Point<int>, complex, complex, complex>::make_DT
	    (new IA_lazy_inv_linear_product_complex (lhs.domain(), lhs, rhs ));
#endif
    } else {
	IA::not_yet_implemented(__FILE__, __LINE__);
    }
 
}


// convolution linear_product zero=0.0 I(complex) I(complex) T(complex)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: img-templ-product,v $
// Revision 1.11.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.11.1.2  1995/01/09  18:19:53  thoth
// Boxy pointset constructor replaced by function.
//
// Revision 1.11.1.1  1994/12/28  18:08:25  thoth
// boxy IPSet constructor is obsolete.
// detect dimension mismatch earlier.
//
// Revision 1.11  1994/12/22  16:31:05  fjsoria
// extra "," in linear product
//
// Revision 1.10  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.9  1994/03/30  14:01:44  thoth
// zero_extension is now a template function.
//
// Revision 1.8  1994/03/14  15:53:13  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.7  1994/02/22  18:49:39  thoth
// We now efficiently evaluate lazy template-template convolutions
// convolved with images.
//
// Revision 1.6  1994/02/12  19:45:43  thoth
// Forward and Backward convolutions are now specified separately.
//
// Revision 1.5  1994/01/31  15:50:18  thoth
// fixed typing error in invariant convolutions.
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:29:46  thoth
// We now have support for forward convolutions.
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/09/15  13:02:08  thoth
// Initial revision
//
// Revision 1.5  93/05/27  11:48:55  thoth
// Copyright Notices
// 
// Revision 1.4  93/04/29  11:20:56  thoth
// Faster(?) extension for VectorDIs.
// 
// Revision 1.3  93/04/17  18:56:44  jnw
// Fixed to match IA_Point<int> membername (dim)
// 
// Revision 1.2  93/04/08  13:21:59  thoth
// internal helper functions are now static.
// 
// Revision 1.1  93/03/18  11:39:42  thoth
// Initial revision
// 

//
// backward convolutions
//

static IA_Image<IA_Point<int>,complex>
backw_linear_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const complex *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,complex> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    complex	*const templ_data = new complex[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	complex	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,complex>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan += ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    complex *const	dest_data = new complex[dest_ps.card()];
    complex *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const complex *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	complex	a = complex(0.,0.); ;

	for (i=0; i<templ_sz; i++) {
	    a += (base[templ_offsets[i]]) * (templ_data[i]); ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,complex>(dest_ps, dest_data, dest_ps.card(), 1);
}

static IA_Image<IA_Point<int>,complex>
backw_linear_product_inv(const IA_Image<IA_Point<int>,complex> &img,
	 const IA_Image<IA_Point<int>,complex> &invtempl,
	 IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,complex>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()+invtempl.domain().inf();
    IA_Point<int>	sup_ = dest_ps.sup()+invtempl.domain().sup();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    complex	*const src_data = new complex[src_ps.card()];

    zero_extend(img, src_ps, (complex*)src_data, complex(0.0));
    IA_Image<IA_Point<int>,complex>	rval =
	backw_linear_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,complex>
linear_product(const IA_Image<IA_Point<int>,complex> &img_,
     const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,complex>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,complex> >	templ(templ_);

#ifdef KNOWN_IA_lazy_linear_product_complex
    if (templ.is_a(IA_lazy_inv_linear_product_complex::s_type())) {
	const IA_lazy_inv_linear_product_complex	*t =
	    (const IA_lazy_inv_linear_product_complex *)IA_FBI<IA_Point<int>, IA_Point<int>, complex, complex, complex>::extract_baseptr(templ);
	IA_Set<IA_Point<int> >	bigger_ps = IA_boxy_pset(
	    IA_Point<int>(dest_ps.inf()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().inf())),
	    IA_Point<int>(dest_ps.sup()+
			(t->rhs(extend_to_point(0, t->rhs.domain().dim()))
			 .domain().sup()))
	    );
	return linear_product(linear_product(img, t->lhs, bigger_ps), t->rhs, dest_ps);
    } else
#else
#define UNKNOWN_IA_lazy_linear_product_complex
#endif
	if (templ.is_a(IA_InvariantDT<IA_Image<IA_Point<int>,complex> >::s_type())) {
	return backw_linear_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,complex> >*)IA_FBI<IA_Point<int>, IA_Point<int>, complex, complex, complex>::extract_baseptr(templ))->value, dest_ps);
//    } else if (templ.type() == IA_Lazy_REDUCT_DT<IA_Image<IA_Point<int>,complex> >::s_type()) {
    } else {
	complex *const	dest_data = new complex[dest_ps.card()];
	complex	*valp = dest_data;
	IA_PSIter<IA_Point<int> >	dest_iter(dest_ps);
	IA_Point<int>	base_ip;
	while (dest_iter(base_ip)) {
	    IA_Image<IA_Point<int>,complex>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,complex>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    complex	templ_val;

	    // _IVAL_=img(ip)
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    complex	a = complex(0.,0.); ;

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! img.domain().contains(ip))
		    continue;
		a += img(ip) * templ_val; ;
	    }
	    {
		(*valp) = a; ;
	    }
	    valp++;
	}
	return IA_Image<IA_Point<int>,complex>(dest_ps, dest_data,
					   dest_ps.card(), 1);
    }
}

// convolution linear_product zero=0.0 I(complex) T(complex) I(complex)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: templ-img-product,v $
// Revision 1.6.1.2  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.6.1.1  1994/12/28  16:56:06  thoth
// Conversion to classes for throw.
//
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/04/15  13:20:18  thoth
// zero_extend is now a function template.
//
// Revision 1.4  1994/03/30  14:02:11  thoth
// zero_extension is now a template function.
//
// Revision 1.3  1994/03/14  15:54:35  thoth
// We now use the FBI to extract the baseptr.
//
// Revision 1.2  1994/02/24  18:26:06  thoth
// prepare for alterations in sed script that allow passing of base
// template container type instead of derived.
//
// Revision 1.1  1994/02/12  19:45:43  thoth
// Initial revision
//


//
// foward convolutions
//

static IA_Image<IA_Point<int>,complex>
forw_linear_product_inv_core(IA_Point<int> src_infimum,
	      IA_Point<int> src_width,
	      const complex *src_data, // length is prod(src_width)
	      const IA_Image<IA_Point<int>,complex> &templ,
	      IA_Set<IA_Point<int> > dest_ps)
{
    const int	dimen = src_width.dim();

    IA_Set<IA_Point<int> >	templ_ps = templ.domain();
    int		templ_sz = templ_ps.card();
    complex	*const templ_data = new complex[templ_sz];
    int	*const templ_offsets = new int[templ_sz];

    {
	complex	*d_scan = templ_data;
	int	*o_scan = templ_offsets;
	IA_IPIter<IA_Point<int>,complex>	iter(templ);
	IA_Point<int>	ip;
	while (iter(ip, *d_scan)) {
	    *o_scan = -ip[0];
	    for (unsigned i=1; i<dimen; i++) {
		*o_scan *= src_width[i];
		*o_scan -= ip[i];
	    }
	    d_scan++;
	    o_scan++;
	}
    }

    IA_PSIter<IA_Point<int> >	iter(dest_ps);
    IA_Point<int>	ip;
    complex *const	dest_data = new complex[dest_ps.card()];
    complex *	valp = dest_data;
    while (iter(ip)) {
	int	offset= ip[0] - src_infimum[0];
	unsigned i;
	for (i=1; i<dimen; i++) {
	    offset *= src_width[i];
	    offset += ip[i] - src_infimum[i];
	}
	const complex *const base = src_data + offset;

	// _IVAL_=(base[templ_offsets[i]])
	// _TVAL_=(templ_data[i])
	// _IRESULT_=(*valp)

	complex	a = complex(0.,0.); ;

	for (i=0; i<templ_sz; i++) {
	    a += (base[templ_offsets[i]]) * (templ_data[i]); ;
	}
	{
	    (*valp) = a; ;
	}
	valp++;
    }
    delete[] templ_offsets;
    delete[] templ_data;

    return IA_Image<IA_Point<int>,complex>(dest_ps, dest_data, dest_ps.card(), 1);
}

static
IA_Image<IA_Point<int>,complex>
forw_linear_product_inv(const IA_Image<IA_Point<int>,complex> &img,
	const IA_Image<IA_Point<int>,complex> &invtempl,
	IA_Set<IA_Point<int> > dest_ps)
{
    if (img.domain().dim() != invtempl.domain().dim()) {
	ia_throw(Template_DimensionMismatch2_Exception(__FILE__, __LINE__));
	return IA_Image<IA_Point<int>,complex>();
    }

    IA_Point<int>	inf_ = dest_ps.inf()-invtempl.domain().sup();
    IA_Point<int>	sup_ = dest_ps.sup()-invtempl.domain().inf();
    IA_Set<IA_Point<int> >	src_ps = IA_boxy_pset(inf_,sup_);

    complex	*const src_data = new complex[src_ps.card()];

    zero_extend(img, src_ps, (complex*)src_data, complex(0.0));
    IA_Image<IA_Point<int>,complex>	rval =
	forw_linear_product_inv_core(inf_, sup_-inf_ + 1, src_data, invtempl, dest_ps);

    delete[] src_data;

    return rval;
}

IA_Image<IA_Point<int>,complex>
linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ_,
     const IA_Image<IA_Point<int>,complex> &img_,
     IA_Set<IA_Point<int> > dest_ps)
{
    IA_Image<IA_Point<int>,complex>	img(img_);
    /*PROMOTE*/IA_DDTemplate<IA_Image<IA_Point<int>,complex> > templ(templ_);

    if (templ.type() == IA_InvariantDT<IA_Image<IA_Point<int>,complex> >::s_type()) {
	return forw_linear_product_inv
	    (img, ((IA_InvariantDT<IA_Image<IA_Point<int>,complex> >*)IA_FBI<IA_Point<int>, IA_Point<int>, complex, complex, complex>::extract_baseptr(templ))->value, dest_ps);
    } else {
	unsigned	size = dest_ps.card();
	complex *const	dest_data = new complex[size];

	for (int i=0; i<size; i++) {
	    // _IRESULT_=dest_data[i]
	    // complex	a = complex(0.,0.); ;
	    dest_data[i]=0.0;
	}

	IA_PSIter<IA_Point<int> >	src_iter(img.domain());
	IA_Point<int>	base_ip;
	while (src_iter(base_ip)) {
	    IA_Image<IA_Point<int>,complex>	tv = templ(base_ip);

	    IA_IPIter<IA_Point<int>,complex>	templ_iter(tv);
	    IA_Point<int>	templ_ip;
	    complex	templ_val;
	    complex	ival = img(base_ip);

	    // _IVAL_=ival
	    // _TVAL_=templ_val
	    // _IRESULT_=(*valp)

	    while ( templ_iter(templ_ip, templ_val) ) {
		const IA_Point<int>	ip = templ_ip; //+base_ip;
		if (! dest_ps.contains(templ_ip))
		    continue;
		unsigned	offset = dest_ps.index(templ_ip);
		complex	*valp = dest_data + offset;
//		cout << "templ(" << base_ip << ") =  " << tv << " and templ()("
//		     << templ_ip <<") = " << templ_val << endl;
		(*valp) += ival * templ_val; ;
	    }
	}
	return IA_Image<IA_Point<int>,complex>(dest_ps, dest_data,
						      size, 1);
    }
}

// reduction sum zero=0.0 I(complex) T(complex)
// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: template-reduction,v $
// Revision 1.6  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.5  1994/02/12  19:46:56  thoth
// *** empty log message ***
//
// Revision 1.4  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.3  1993/12/29  17:33:18  thoth
// New operator scheme that prevents the need for trivial Image conversions.
//
// Revision 1.2  1993/11/17  18:45:07  thoth
// IPSIter is now PSIter<IntPoint>.
//
// Revision 1.1  1993/10/20  18:32:02  thoth
// Initial revision
//

IA_Image<IA_Point<int>, complex>
sum(IA_Set<IA_Point<int> > domain,
       IA_DDTemplate<IA_Image<IA_Point<int>,complex> > templ,
       IA_Set<IA_Point<int> > dest_domain)
{
    IA_Image<IA_Point<int>, complex>	rval(dest_domain, (complex)0.0);

    IA_PSIter<IA_Point<int> >	psiter(domain);
    IA_Point<int>	scan;

    while (psiter(scan)) {
	IA_Image<IA_Point<int>,complex>	curr = templ(scan);
	IA_IPIter<IA_Point<int>, complex>	iiter(curr);
	IA_Point<int>	p;
	complex	val;
	// _IRESULT_=rval[p]
	// _TVAL_=val

	while (iiter(p,val)) {
	    if (rval.domain().contains(p)) {
		rval[p] += val; ;
	    }
	}
    }
    return rval;
}

// end reduction
