// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ConstI.h,v $
// Revision 1.5.1.1  1994/12/28  16:41:19  thoth
// Pass T by value (avoids problem with const float&).
// conversion to classes for throw.
//
// Revision 1.5  1994/07/25  17:24:13  thoth
// Name sanitization
//
// Revision 1.4  1994/03/14  15:48:33  thoth
// ValueSet has been replaced by container class Set.
//
// Revision 1.3  1994/02/26  16:02:08  thoth
// operator() of the container now relies upon the contained classes
// to check if p is contained in the domain.  This means that users
// could possibly write an erroneous operator().
//
// Revision 1.2  1993/11/17  18:12:47  thoth
// extensivep is now extensive
//
// Revision 1.1  1993/09/15  12:51:13  thoth
// Initial revision
//

#ifndef ConstI_h_
#define ConstI_h_

#include "BaseI.h"
#include "image_errors.h"

template < class P,class T> class IA_ConstIVIter;
template < class P,class T> class IA_ConstIPIter;

template < class P,class T>
class IA_ConstI: public IA_BaseImage<P,T> {
public:
    static char dummy;

    T value;
public:
    IA_ConstI(const IA_Set<P>& p,  T val)
    : IA_BaseImage<P,T>(p), value(val) { }

    int extensive() const { return 0; }

    T operator ()(const P &p) const {
	if (!domain().contains(p)) {
	    ia_throw(Image_PointOutsideDomain_Exception(__FILE__,__LINE__));
	}
	return value;
    }

    // ~IA_ConstI() {}

    static IA::Type s_type() { return &dummy; }

    IA::Type type() const { return &dummy; }

    IA_BaseImage<P,T>* clone_self_extensively() const;

    IA_Set<T> range() const;

    IA_Array<T> value_array() const;

#if 0
    IA_BaseImage<IA_Point<int>,T> * restricted_to(const IA_Point<int>Set &ps) const
#if 1
	;
#else
    {
	return new IA_ConstI<IA_Point<int>,T>(this->domain() & ps, this->value);
    }
#endif

    IA_BaseImage<P,T> * restricted_to(const IA_Point<double>Set &ps) const
#if 1
    ;
#else
    {
	return new IA_ConstI<P,T>(this->domain() & ps, this->value);
    }
#endif
#endif
    
    IA_BaseImage<P,T> * xlated_by(const P &p) const {
	return new IA_ConstI<P,T>(this->domain()+p, this->value);
    }

    IA_BaseIVIter<P,T> *value_iterator() const;
    IA_BaseIPIter<P,T> *pixel_iterator() const;

    ostream& print_this(ostream&) const;

    friend class IA_ConstIVIter<P,T>;
    friend class IA_ConstIPIter<P,T>;
};

#endif
