// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: ClosureDT.h,v $
// Revision 1.5  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.4  1994/02/22  18:46:25  thoth
// New is_a virtual method, used to determine if an object is of a
// class derived from another class.
//
// Revision 1.3  1994/02/12  19:34:43  thoth
// Using IA::Type instead of the IA_DiscreteImageType typedef.
//
// Revision 1.2  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.1  1993/09/15  12:55:38  thoth
// Initial revision
//
// Revision 1.3  93/05/27  11:22:39  thoth
// Copyright Notices
// 
// Revision 1.2  93/04/08  13:20:42  thoth
// Templates are now separate from images.
// 
// Revision 1.1  93/03/18  11:07:37  thoth
// Initial revision
// 

#ifndef ClosureDT_h_
#define ClosureDT_h_

#include "BaseDT.h"

template <class I>
class IA_ClosureDT: public IA_BaseDT<I> {
  private:
    static char	dummy;
  public:
    IA_ClosureDT(const IA_Set<IA_Point<int> > &ps)
    :IA_BaseDT<I>(ps) { }

    virtual IA_ClosureDT<I> *clone_self() const =0;

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }
    int is_a(IA::Type t) { return t == s_type() ; }

    ostream &print_this(ostream &o) const { return o<<"User-defined template\n"; }

    // the user must provide
    // I operator()(const IA_Point<int> &p) const
    // IA_ClosureDT<I> *clone_self() const;
};

// should go in ClosureDT.c
template <class I>
char IA_ClosureDT<I>::dummy;

#endif
