// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: cplx-operations.desc,v $
//  Revision 1.8.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.8.1.1  1994/12/28  18:06:11  thoth
//  image operations are now friendly with FBI.
//  image ops now use operations table instead of switch.

//  Revision 1.8  1994/12/19  19:58:48  ljr
//  DOS-inspired name rework.

//  Revision 1.7  1994/08/22  15:20:29  thoth
//  DOS-inspired name rework.

//  Revision 1.6  1994/05/27  15:33:15  thoth
//  Pass-through C code wasn't passing through.

//  Revision 1.5  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Revision 1.4  1994/02/03  16:22:48  thoth
//  Arguments to binary operations were specified "lhs rhs return" but are
//  now specified "return lhs rhs" to be consistent with function declaration
//  syntax.

//  Revision 1.3  1994/01/31  15:54:13  thoth
//  chi_functions now return BitDIs.
//  more pointwise complex functions.

//  Revision 1.2  1993/12/29  17:27:24  thoth
//  reductions require a zero now.

//  Revision 1.1  1993/11/29  22:25:25  thoth
//  Initial revision

// include <complex.h>
#include "CplxDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative chi_eq subop=operator== I(IA_Bit) I(complex) I(complex)
//
#ifndef BOT_IA_Bit_complex_complex_chi_eq
#define BOT_IA_Bit_complex_complex_chi_eq
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, complex>,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl;

void IA_fill_Image_IP_IA_Bit_complex_complex_chi_eq_tbl();

#endif // BOT_IA_Bit_complex_complex_chi_eq
IA_Image<IA_Point<int>, IA_Bit>
chi_eq ( const IA_Image<IA_Point<int>, complex> &lhs,
		const IA_Image<IA_Point<int>, complex> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 IA_Image<IA_Point<int>, IA_Bit>	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl)
	IA_fill_Image_IP_IA_Bit_complex_complex_chi_eq_tbl();

    IA_BaseImage<IA_Point<int>, IA_Bit>*(*f)( IA_BaseImage<IA_Point<int>, complex> &,
		IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,complex>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, complex,complex,complex>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,complex>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, complex,complex,complex>
	    ::extract_baseptr(rhs);
    return IA_Image<IA_Point<int>,IA_Bit>
	(IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_vec_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, complex> *lhs
		= (IA_VectorI<IA_Point<int>, complex> *)&lhs_;
	const complex *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, complex> *rhs
		= (IA_VectorI<IA_Point<int>, complex> *)&rhs_;
	const complex *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) == (*rs) );
	    ls++;
	    rs++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef vec_scalar_IA_Bit_complex_complex_chi_eq
#define vec_scalar_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, complex> *lhs
		= (IA_VectorI<IA_Point<int>, complex> *)&lhs_;
	const complex *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, complex> *rhs
		= (IA_ConstI<IA_Point<int>, complex> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) == (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // vec_scalar_IA_Bit_complex_complex_chi_eq

static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, complex> *lhs
		= (IA_VectorI<IA_Point<int>, complex> *)&lhs_;
	const complex *ls = lhs->vec;
	complex rtmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (*ls) == (rtmp) );
	    ls++;
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef scalar_vec_IA_Bit_complex_complex_chi_eq
#define scalar_vec_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_vec_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    return vec_scalar_bo_chi_eq(rhs_, lhs_);
}
#endif // scalar_vec_IA_Bit_complex_complex_chi_eq

#ifndef scalar_scalar_IA_Bit_complex_complex_chi_eq
#define scalar_scalar_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, complex> *lhs
		= (IA_ConstI<IA_Point<int>, complex> *)&lhs_;
	IA_ConstI<IA_Point<int>, complex> *rhs
		= (IA_ConstI<IA_Point<int>, complex> *)&rhs_;
    IA_Bit	aval = ( lhs->value == rhs->value );
    return new IA_ConstI<IA_Point<int>, IA_Bit>(domain, aval);
}
#endif // scalar_scalar_IA_Bit_complex_complex_chi_eq

#ifndef scalar_iter_IA_Bit_complex_complex_chi_eq
#define scalar_iter_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_ConstI<IA_Point<int>, complex> *lhs
		= (IA_ConstI<IA_Point<int>, complex> *)&lhs_;
	complex rtmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) == (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // scalar_iter_IA_Bit_complex_complex_chi_eq

static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_vec_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    return vec_iter_bo_chi_eq(rhs_, lhs_);
}

#ifndef iter_scalar_IA_Bit_complex_complex_chi_eq
#define iter_scalar_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    return scalar_iter_bo_chi_eq(rhs_, lhs_);
}
#endif // iter_scalar_IA_Bit_complex_complex_chi_eq

static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	complex ltmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*liter = lhs_.value_iterator();
	complex rtmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    *(ds++) = ( (ltmp) == (rtmp) );
	}
	delete liter;
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}

#ifndef FILL_BOT_IA_Bit_complex_complex_chi_eq
#define FILL_BOT_IA_Bit_complex_complex_chi_eq
void IA_fill_Image_IP_IA_Bit_complex_complex_chi_eq_tbl()
{
    if (IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, complex>,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_iter_bo_chi_eq;

    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, complex>,
	IA_BaseImage<IA_Point<int>, complex> >(iter_iter_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 IA_ConstI<IA_Point<int>, complex>::s_type(),
	 vec_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 0,
	 vec_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 IA_VectorI<IA_Point<int>, complex>::s_type(),
	 scalar_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 0,
	 scalar_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, complex>::s_type(),
	 iter_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, complex>::s_type(),
	 iter_scalar_bo_chi_eq);

}
#endif // BOT_IA_Bit_complex_complex_chi_eq

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary pointwise commutative chi_eq subop=operator== I(IA_Bit) I(complex) complex
//
#ifndef BOT_IA_Bit_complex_complex_chi_eq
#define BOT_IA_Bit_complex_complex_chi_eq
IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, complex>,
	IA_BaseImage<IA_Point<int>, complex> >
	*IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl;

void IA_fill_Image_IP_IA_Bit_complex_complex_chi_eq_tbl();

#endif // BOT_IA_Bit_complex_complex_chi_eq
IA_Image<IA_Point<int>, IA_Bit>
chi_eq ( const IA_Image<IA_Point<int>, complex> &lhs,
		complex rhs)
{
    if (!IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl)
	IA_fill_Image_IP_IA_Bit_complex_complex_chi_eq_tbl();

    IA_BaseImage<IA_Point<int>, IA_Bit>*(*f)( IA_BaseImage<IA_Point<int>, complex> &,
		IA_BaseImage<IA_Point<int>, complex> &);
    f = IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, complex>::s_type());
    IA_BaseImage<IA_Point<int>,complex>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, complex,complex,complex>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,complex>	baser(lhs.domain(), rhs);
    return IA_Image<IA_Point<int>,IA_Bit>
	(IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	 ::make_Image(	 f(basel,baser)));
}

//
//
//

#ifndef vec_scalar_IA_Bit_complex_complex_chi_eq
#define vec_scalar_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
vec_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_VectorI<IA_Point<int>, complex> *lhs
		= (IA_VectorI<IA_Point<int>, complex> *)&lhs_;
	const complex *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, complex> *rhs
		= (IA_ConstI<IA_Point<int>, complex> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    *(ds++) = ( (*ls) == (rhs->value) );
	    ls++;
	}
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // vec_scalar_IA_Bit_complex_complex_chi_eq

#ifndef scalar_scalar_IA_Bit_complex_complex_chi_eq
#define scalar_scalar_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, complex> *lhs
		= (IA_ConstI<IA_Point<int>, complex> *)&lhs_;
	IA_ConstI<IA_Point<int>, complex> *rhs
		= (IA_ConstI<IA_Point<int>, complex> *)&rhs_;
    IA_Bit	aval = ( lhs->value == rhs->value );
    return new IA_ConstI<IA_Point<int>, IA_Bit>(domain, aval);
}
#endif // scalar_scalar_IA_Bit_complex_complex_chi_eq

#ifndef scalar_iter_IA_Bit_complex_complex_chi_eq
#define scalar_iter_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
scalar_iter_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    IA_Bit *const vec = new IA_Bit[sz];

    {
	IA_Bit *ds = vec;
	IA_ConstI<IA_Point<int>, complex> *lhs
		= (IA_ConstI<IA_Point<int>, complex> *)&lhs_;
	complex rtmp;
	IA_BaseIVIter<IA_Point<int>, complex>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    *(ds++) = ( (lhs->value) == (rtmp) );
	}
	delete riter;
    }
    return new IA_VectorI<IA_Point<int>, IA_Bit>(domain, vec, sz, 1);
}
#endif // scalar_iter_IA_Bit_complex_complex_chi_eq

#ifndef iter_scalar_IA_Bit_complex_complex_chi_eq
#define iter_scalar_IA_Bit_complex_complex_chi_eq
static IA_BaseImage<IA_Point<int>, IA_Bit> *
iter_scalar_bo_chi_eq(IA_BaseImage<IA_Point<int>, complex> &lhs_,
	IA_BaseImage<IA_Point<int>, complex> &rhs_)
{
    return scalar_iter_bo_chi_eq(rhs_, lhs_);
}
#endif // iter_scalar_IA_Bit_complex_complex_chi_eq

#ifndef FILL_BOT_IA_Bit_complex_complex_chi_eq
#define FILL_BOT_IA_Bit_complex_complex_chi_eq
void IA_fill_Image_IP_IA_Bit_complex_complex_chi_eq_tbl()
{
    if (IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl)
	return;

    IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, complex>,
	IA_BaseImage<IA_Point<int>, complex> >::function f;
    f = iter_iter_bo_chi_eq;

    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl = new IA_BinaryOperationsTable<IA_BaseImage<IA_Point<int>, IA_Bit>*,
	IA_BaseImage<IA_Point<int>, complex>,
	IA_BaseImage<IA_Point<int>, complex> >(iter_iter_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 IA_VectorI<IA_Point<int>, complex>::s_type(),
	 vec_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 IA_ConstI<IA_Point<int>, complex>::s_type(),
	 vec_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_VectorI<IA_Point<int>, complex>::s_type(),
	 0,
	 vec_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 IA_VectorI<IA_Point<int>, complex>::s_type(),
	 scalar_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 IA_ConstI<IA_Point<int>, complex>::s_type(),
	 scalar_scalar_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(IA_ConstI<IA_Point<int>, complex>::s_type(),
	 0,
	 scalar_iter_bo_chi_eq);

    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, complex>::s_type(),
	 iter_vec_bo_chi_eq);
    IA_Image_IP_IA_Bit_complex_complex_chi_eq_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, complex>::s_type(),
	 iter_scalar_bo_chi_eq);

}
#endif // BOT_IA_Bit_complex_complex_chi_eq

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename CIO-X_ne.c
//
