// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: BaseImageIter.h,v $
// Revision 1.1  1993/09/15  12:50:42  thoth
// Initial revision
//

#ifndef BaseImageIter_h_
#define BaseImageIter_h_

#include "Point.h"

template <class P,class T> class IA_BaseImage;

template < class P,class T>
class IA_BaseIVIter {
protected:

    // This is the image over whose pixels we are iterating.
    IA_BaseImage<P,T> *domain;

public:

    IA_BaseIVIter(const IA_BaseImage<P,T> *x);

    virtual ~IA_BaseIVIter();

    // this returns a pointer to a copy of the object
    virtual IA_BaseIVIter * clone_self() =0;

    // If the iterator has reached the end, the next() method will return 0.
    // Otherwise it will set the reference parameter to the
    // (lexicographically) next pixel in the image and return 1.

    virtual int next(T&) = 0;

    // this method resets the iterator to the beginning of the point set
    virtual void reset() = 0;

    IA_BaseImage<P,T> *domain_() const { return this->domain; }
};

template < class P,class T>
class IA_BaseIPIter {
protected:

    // This is the image over whose pixels we are iterating.
    IA_BaseImage<P,T> *domain;

public:

    IA_BaseIPIter(const IA_BaseImage<P,T> *x);

    virtual ~IA_BaseIPIter() {}

    // this returns a pointer to a copy of the object
    virtual IA_BaseIPIter * clone_self() =0;

    // If the iterator has reached the end, the next() method will return 0.
    // Otherwise it will set the reference parameter to the
    // (lexicographically) next pixel in the image and return 1.

    virtual int next(P&, T&) = 0;

    // this method resets the iterator to the beginning of the point set
    virtual void reset() = 0;

    IA_BaseImage<P,T> *domain_() const{ return this->domain; }
};

#endif
