// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: BaseImageIter.c,v $
// Revision 1.2  1993/09/21  11:42:48  thoth
// Some guards to make the base class handle the error iterators.
//
// Revision 1.1  93/09/15  12:50:31  thoth
// Initial revision
// 

#include "BaseImageIter.h"
#include "BaseI.h"

template < class P,class T>
IA_BaseIVIter<P,T>::IA_BaseIVIter(const IA_BaseImage<P,T> *x)
{
    // cast away const
    domain = (IA_BaseImage<P,T>*)x;
    if (domain)			// ErrorIters pass 0
	domain->incr_ref();
}

template < class P,class T>
IA_BaseIVIter<P,T>::~IA_BaseIVIter()
{
    if (domain			// ErrorIters pass 0
	&& domain->decr_ref()<=0)
	    delete domain;
    domain = 0;
}

//
//
//

template < class P,class T>
IA_BaseIPIter<P,T>::IA_BaseIPIter(const IA_BaseImage<P,T> *x)
{
    // cast away const
    domain = (IA_BaseImage<P,T>*)x;
    if (domain)
	domain->incr_ref();
}

template < class P,class T>
IA_BaseIPIter<P,T>::~IA_BaseIPIter()
{
    if (domain
	&& domain->decr_ref()<=0)
	delete domain;
    domain = 0;
}
