// Emacs -*- C++ -*-

// Machine generated include file, do not modify.


// 	Copyright 1993, Center for Computer Vision and Visualization,
// 	University of Florida.  All rights reserved.


//  $Log: bit-operations.desc,v $
//  Revision 1.6.1.2  1995/01/31  16:02:40  thoth
//  Need to replace the upward conversions with something...

//  Revision 1.6.1.1  1994/12/28  17:49:18  thoth
//  Image operations are now friendly with FBI.
//  Image ops now use operations table instead of switch.

//  Revision 1.6  1994/08/22  15:20:29  thoth
//  DOS-inspired name rework.

//  Revision 1.5  1994/05/17  12:54:56  thoth
//  Improved operations generation scheme.  Lines from the op.desc file can
//  be quoted into the .c file to allow inclusion of infrastructure.  Also
//  the op.desc output can be redirected to several files.  The prefix
//  directive allows common information (include files) to be included in
//  every generated source file.

//  Revision 1.4  1994/02/03  16:22:48  thoth
//  Arguments to binary operations were specified "lhs rhs return" but are
//  now specified "return lhs rhs" to be consistent with function declaration
//  syntax.

//  Revision 1.3  1994/01/31  15:51:12  thoth
//  converters to CoreImages now available.

//  Revision 1.2  1993/12/29  17:16:45  thoth
//  Bit Discrete Image now uses Bit type.

//  Revision 1.1  1993/11/29  22:25:25  thoth
//  Initial revision


#include "BitDI.h"
#include "VectorI.h"
#include "ConstI.h"
#include "ImageIter.h"
#include "FBI.h"
#include "../valueset/OpTable.h"
//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= int I(IA_Bit) I(IA_Bit)
//
#ifndef BOT_int_IA_Bit_IA_Bit_strict_ne
#define BOT_int_IA_Bit_IA_Bit_strict_ne
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit>,
	IA_BaseImage<IA_Point<int>, IA_Bit> >
	*IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl;

void IA_fill_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl();

#endif // BOT_int_IA_Bit_IA_Bit_strict_ne
int strict_ne ( const IA_Image<IA_Point<int>, IA_Bit> &lhs,
		const IA_Image<IA_Point<int>, IA_Bit> &rhs)
{
    if (lhs.domain() != rhs.domain()) {
	 int	rval;
	ia_throw(Image_DomainMismatch_Exception(__FILE__,__LINE__));
	return rval;
    }

    if (!IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl)
	IA_fill_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, IA_Bit> &,
		IA_BaseImage<IA_Point<int>, IA_Bit> &);
    f = IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->lookup_operation
	(lhs.type(), rhs.type());
    IA_BaseImage<IA_Point<int>,IA_Bit>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	    ::extract_baseptr(lhs);
    IA_BaseImage<IA_Point<int>,IA_Bit>	&baser = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	    ::extract_baseptr(rhs);
    return 	 f(basel,baser);
}

//
//
//

static int vec_vec_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_Bit> *lhs
		= (IA_VectorI<IA_Point<int>, IA_Bit> *)&lhs_;
	const IA_Bit *ls = lhs->vec;
	IA_VectorI<IA_Point<int>, IA_Bit> *rhs
		= (IA_VectorI<IA_Point<int>, IA_Bit> *)&rhs_;
	const IA_Bit *rs = rhs->vec;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) != (*rs) ))
		return 0;
	    ls++;
	    rs++;
	}
    }
    return 1;
}

#ifndef vec_scalar_int_IA_Bit_IA_Bit_strict_ne
#define vec_scalar_int_IA_Bit_IA_Bit_strict_ne
static int vec_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_Bit> *lhs
		= (IA_VectorI<IA_Point<int>, IA_Bit> *)&lhs_;
	const IA_Bit *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_Bit> *rhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) != (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_IA_Bit_IA_Bit_strict_ne

static int vec_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_Bit> *lhs
		= (IA_VectorI<IA_Point<int>, IA_Bit> *)&lhs_;
	const IA_Bit *ls = lhs->vec;
	IA_Bit rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_Bit>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (*ls) != (rtmp) ))
		return 0;
	    ls++;
	}
	delete riter;
    }
    return 1;
}

#ifndef scalar_vec_int_IA_Bit_IA_Bit_strict_ne
#define scalar_vec_int_IA_Bit_IA_Bit_strict_ne
static int scalar_vec_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    return vec_scalar_bo_strict_ne(rhs_, lhs_);
}
#endif // scalar_vec_int_IA_Bit_IA_Bit_strict_ne

#ifndef scalar_scalar_int_IA_Bit_IA_Bit_strict_ne
#define scalar_scalar_int_IA_Bit_IA_Bit_strict_ne
static int scalar_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_Bit> *lhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_Bit> *rhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&rhs_;
    int	aval = ( lhs->value != rhs->value );
    return aval;
}
#endif // scalar_scalar_int_IA_Bit_IA_Bit_strict_ne

#ifndef scalar_iter_int_IA_Bit_IA_Bit_strict_ne
#define scalar_iter_int_IA_Bit_IA_Bit_strict_ne
static int scalar_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, IA_Bit> *lhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&lhs_;
	IA_Bit rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_Bit>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) != (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_IA_Bit_IA_Bit_strict_ne

static int iter_vec_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    return vec_iter_bo_strict_ne(rhs_, lhs_);
}

#ifndef iter_scalar_int_IA_Bit_IA_Bit_strict_ne
#define iter_scalar_int_IA_Bit_IA_Bit_strict_ne
static int iter_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    return scalar_iter_bo_strict_ne(rhs_, lhs_);
}
#endif // iter_scalar_int_IA_Bit_IA_Bit_strict_ne

static int iter_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_Bit ltmp;
	IA_BaseIVIter<IA_Point<int>, IA_Bit>	*liter = lhs_.value_iterator();
	IA_Bit rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_Bit>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    liter->next(ltmp);
	    riter->next(rtmp);
	    if (!( (ltmp) != (rtmp) ))
		return 0;
	}
	delete liter;
	delete riter;
    }
    return 1;
}

#ifndef FILL_BOT_int_IA_Bit_IA_Bit_strict_ne
#define FILL_BOT_int_IA_Bit_IA_Bit_strict_ne
void IA_fill_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl()
{
    if (IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit>,
	IA_BaseImage<IA_Point<int>, IA_Bit> >::function f;
    f = iter_iter_bo_strict_ne;

    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit>,
	IA_BaseImage<IA_Point<int>, IA_Bit> >(iter_iter_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 vec_vec_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 vec_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 0,
	 vec_iter_bo_strict_ne);

    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 scalar_vec_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 scalar_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 0,
	 scalar_iter_bo_strict_ne);

    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 iter_vec_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 iter_scalar_bo_strict_ne);

}
#endif // BOT_int_IA_Bit_IA_Bit_strict_ne

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// binary strictrel commutative strict_ne subop=operator!= int I(IA_Bit) IA_Bit
//
#ifndef BOT_int_IA_Bit_IA_Bit_strict_ne
#define BOT_int_IA_Bit_IA_Bit_strict_ne
IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit>,
	IA_BaseImage<IA_Point<int>, IA_Bit> >
	*IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl;

void IA_fill_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl();

#endif // BOT_int_IA_Bit_IA_Bit_strict_ne
int strict_ne ( const IA_Image<IA_Point<int>, IA_Bit> &lhs,
		IA_Bit rhs)
{
    if (!IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl)
	IA_fill_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl();

    int(*f)( IA_BaseImage<IA_Point<int>, IA_Bit> &,
		IA_BaseImage<IA_Point<int>, IA_Bit> &);
    f = IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->lookup_operation
	(lhs.type(), IA_ConstI<IA_Point<int>, IA_Bit>::s_type());
    IA_BaseImage<IA_Point<int>,IA_Bit>	&basel = *IA_FBI<IA_Point<int>,IA_Point<int>, IA_Bit,IA_Bit,IA_Bit>
	    ::extract_baseptr(lhs);
    IA_ConstI<IA_Point<int>,IA_Bit>	baser(lhs.domain(), rhs);
    return 	 f(basel,baser);
}

//
//
//

#ifndef vec_scalar_int_IA_Bit_IA_Bit_strict_ne
#define vec_scalar_int_IA_Bit_IA_Bit_strict_ne
static int vec_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_VectorI<IA_Point<int>, IA_Bit> *lhs
		= (IA_VectorI<IA_Point<int>, IA_Bit> *)&lhs_;
	const IA_Bit *ls = lhs->vec;
	IA_ConstI<IA_Point<int>, IA_Bit> *rhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&rhs_;
	for (unsigned i=0; i<sz; i++) {
	    if (!( (*ls) != (rhs->value) ))
		return 0;
	    ls++;
	}
    }
    return 1;
}
#endif // vec_scalar_int_IA_Bit_IA_Bit_strict_ne

#ifndef scalar_scalar_int_IA_Bit_IA_Bit_strict_ne
#define scalar_scalar_int_IA_Bit_IA_Bit_strict_ne
static int scalar_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
	IA_ConstI<IA_Point<int>, IA_Bit> *lhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&lhs_;
	IA_ConstI<IA_Point<int>, IA_Bit> *rhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&rhs_;
    int	aval = ( lhs->value != rhs->value );
    return aval;
}
#endif // scalar_scalar_int_IA_Bit_IA_Bit_strict_ne

#ifndef scalar_iter_int_IA_Bit_IA_Bit_strict_ne
#define scalar_iter_int_IA_Bit_IA_Bit_strict_ne
static int scalar_iter_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    const IA_Set<IA_Point<int> > domain = lhs_.domain();
    const unsigned sz = domain.card();
    int *const vec = new int[sz];

    {
	int *ds = vec;
	IA_ConstI<IA_Point<int>, IA_Bit> *lhs
		= (IA_ConstI<IA_Point<int>, IA_Bit> *)&lhs_;
	IA_Bit rtmp;
	IA_BaseIVIter<IA_Point<int>, IA_Bit>	*riter = rhs_.value_iterator();
	for (unsigned i=0; i<sz; i++) {
	    riter->next(rtmp);
	    if (!( (lhs->value) != (rtmp) ))
		return 0;
	}
	delete riter;
    }
    return 1;
}
#endif // scalar_iter_int_IA_Bit_IA_Bit_strict_ne

#ifndef iter_scalar_int_IA_Bit_IA_Bit_strict_ne
#define iter_scalar_int_IA_Bit_IA_Bit_strict_ne
static int iter_scalar_bo_strict_ne(IA_BaseImage<IA_Point<int>, IA_Bit> &lhs_,
	IA_BaseImage<IA_Point<int>, IA_Bit> &rhs_)
{
    return scalar_iter_bo_strict_ne(rhs_, lhs_);
}
#endif // iter_scalar_int_IA_Bit_IA_Bit_strict_ne

#ifndef FILL_BOT_int_IA_Bit_IA_Bit_strict_ne
#define FILL_BOT_int_IA_Bit_IA_Bit_strict_ne
void IA_fill_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl()
{
    if (IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl)
	return;

    IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit>,
	IA_BaseImage<IA_Point<int>, IA_Bit> >::function f;
    f = iter_iter_bo_strict_ne;

    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl = new IA_BinaryOperationsTable<int,
	IA_BaseImage<IA_Point<int>, IA_Bit>,
	IA_BaseImage<IA_Point<int>, IA_Bit> >(iter_iter_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 vec_vec_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 vec_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 0,
	 vec_iter_bo_strict_ne);

    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 scalar_vec_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 scalar_scalar_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 0,
	 scalar_iter_bo_strict_ne);

    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(0,
	 IA_VectorI<IA_Point<int>, IA_Bit>::s_type(),
	 iter_vec_bo_strict_ne);
    IA_Image_IP_int_IA_Bit_IA_Bit_strict_ne_tbl->add_operation
	(0,
	 IA_ConstI<IA_Point<int>, IA_Bit>::s_type(),
	 iter_scalar_bo_strict_ne);

}
#endif // BOT_int_IA_Bit_IA_Bit_strict_ne

//////////////////////////////////////////////////////////////////////
//
// Begin operation support routines for :
// filename BIO-reductions.c
//
