//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: bit-conv.desc,v $
// Revision 1.3  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.2  1993/12/29  17:16:45  thoth
// Bit Discrete Image now uses Bit type.
//
// Revision 1.1  1993/11/29  22:25:25  thoth
// Initial revision
//
// 
// The XOR for the hit-miss transform is implemented using logical operators
// instead of the bitwise '^' to guarantee that only values of 1 and 0
// result.
// convolution hit_miss zero=1 I(IA_Bit) I(IA_Bit) T(IA_Bit)
friend IA_Image<IA_Point<int>,IA_Bit> hit_miss(const IA_Image<IA_Point<int>,IA_Bit> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution hit_miss zero=1 I(IA_Bit) T(IA_Bit) I(IA_Bit)
friend IA_Image<IA_Point<int>,IA_Bit> hit_miss(const IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> > &templ,
		const IA_Image<IA_Point<int>,IA_Bit> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: uchar-conv.desc,v $
// Revision 1.5  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.4  1993/11/17  18:45:15  thoth
// forward convolutions are now supported.
// template reductions are now supported.
//
// Revision 1.3  1993/09/27  15:55:30  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
//
// Revision 1.2  1993/09/21  11:45:04  thoth
// Give uchar convolutions the proper names.
//
// Revision 1.1  93/09/15  13:05:15  thoth
// Initial revision
// 
// Revision 1.2  93/05/27  11:41:16  thoth
// Copyright Notices
// 
// Revision 1.1  93/03/18  11:26:37  thoth
// Initial revision
// 
// convolution linear_product zero=0 I(u_char) I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> linear_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution linear_product zero=0 I(u_char) T(u_char) I(u_char)
friend IA_Image<IA_Point<int>,u_char> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
//the following is especially suspect.  What if there was NO
//intersection between the original image and the template.  We get the
//max value of the template, not the minimum value of the uchar ( 0 ).
//  *sigh*
// convolution addmax_product zero=0 I(u_char) I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> addmax_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution addmax_product zero=0 I(u_char) T(u_char) I(u_char)
friend IA_Image<IA_Point<int>,u_char> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution addmin_product zero=255 I(u_char) I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> addmin_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution addmin_product zero=255 I(u_char) T(u_char) I(u_char)
friend IA_Image<IA_Point<int>,u_char> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

// take advantage of the fact that we are doing integer arithmetic and
// probably have extra precision lying around.  If the ints on your
// machine are not twice the size of chars (almost impossible) then use
// a long for the temp variable
// convolution multmax_product zero=0 I(u_char) I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> multmax_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution multmax_product zero=0 I(u_char) T(u_char) I(u_char)
friend IA_Image<IA_Point<int>,u_char> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

// what do we do when the template has a zero and the image is
// undefined?  Currently we multiply +infty (255) by zero and get 0, a
// minimum value.  crap.
// convolution multmin_product zero=255 I(u_char) I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> multmin_product(const IA_Image<IA_Point<int>,u_char> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution multmin_product zero=255 I(u_char) T(u_char) I(u_char)
friend IA_Image<IA_Point<int>,u_char> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > &templ,
		const IA_Image<IA_Point<int>,u_char> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
//
// reduction sum zero=0 I(int) T(u_char)
friend IA_Image<IA_Point<int>,int> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction max zero=0 I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> max(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction min zero=255 I(u_char) T(u_char)
friend IA_Image<IA_Point<int>,u_char> min(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,u_char> > templ,
	IA_Set<IA_Point<int> > dest_domain);

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: int-conv.desc,v $
// Revision 1.7  1994/02/24  18:25:47  thoth
// You can now convolve IntDDTemplates.
//
// Revision 1.6  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.5  1994/01/07  15:24:53  thoth
// Template reductions had wrong ring zeros.
//
// Revision 1.4  1993/11/17  18:41:07  thoth
// forward convolutions are now supported.
// template reductions are now supported.
//
// Revision 1.3  1993/09/27  15:54:56  thoth
// Make the xxxmax_product and xxxmin_product functions a little more robust.
//
// Revision 1.2  93/09/21  11:44:32  thoth
// remove cruft that belongs in double-convolutions.desc
// 
// Revision 1.1  93/09/15  13:04:31  thoth
// Initial revision
// 
// Revision 1.3  93/05/27  11:41:13  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// convolution linear_product T(int) T(int) T(int)
friend IA_DDTemplate<IA_Image<IA_Point<int>,int> > linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &img);

// convolution linear_product zero=0 I(int) I(int) T(int)
friend IA_Image<IA_Point<int>,int> linear_product(const IA_Image<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution linear_product zero=0 I(int) T(int) I(int)
friend IA_Image<IA_Point<int>,int> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		const IA_Image<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

// we have to be careful doing the following transforms
// machine integers are NOT mathematical integers...
// convolution addmax_product zero=-MAXINT I(int) I(int) T(int)
friend IA_Image<IA_Point<int>,int> addmax_product(const IA_Image<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution addmax_product zero=-MAXINT I(int) T(int) I(int)
friend IA_Image<IA_Point<int>,int> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		const IA_Image<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution addmin_product zero=MAXINT I(int) I(int) T(int)
friend IA_Image<IA_Point<int>,int> addmin_product(const IA_Image<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution addmin_product zero=MAXINT I(int) T(int) I(int)
friend IA_Image<IA_Point<int>,int> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		const IA_Image<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution multmax_product zero=-1 I(int) I(int) T(int)
friend IA_Image<IA_Point<int>,int> multmax_product(const IA_Image<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution multmax_product zero=-1 I(int) T(int) I(int)
friend IA_Image<IA_Point<int>,int> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		const IA_Image<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution multmin_product zero=-1 I(int) I(int) T(int)
friend IA_Image<IA_Point<int>,int> multmin_product(const IA_Image<IA_Point<int>,int> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution multmin_product zero=-1 I(int) T(int) I(int)
friend IA_Image<IA_Point<int>,int> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &templ,
		const IA_Image<IA_Point<int>,int> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
//
// reduction sum zero=0 I(int) T(int)
friend IA_Image<IA_Point<int>,int> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction max zero=-MAXINT I(int) T(int)
friend IA_Image<IA_Point<int>,int> max(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction min zero=MAXINT I(int) T(int)
friend IA_Image<IA_Point<int>,int> min(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,int> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// binary operator+ zero=0 gamma=sum T(int) T(int) T(int)
friend IA_DDTemplate<IA_Image<IA_Point<int>,int> > operator+(
	const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &t1,
	const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &t2);

// binary min zero=MAXINT gamma=min T(int) T(int) T(int)
friend IA_DDTemplate<IA_Image<IA_Point<int>,int> > min(
	const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &t1,
	const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &t2);

// binary max zero=-MAXINT gamma=max T(int) T(int) T(int)
friend IA_DDTemplate<IA_Image<IA_Point<int>,int> > max(
	const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &t1,
	const IA_DDTemplate<IA_Image<IA_Point<int>,int> > &t2);

// convolution linear_product zero=0 gamma=sum circle=product T(int) T(int) T(int)
//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: float-conv.desc,v $
// Revision 1.3  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.2  1993/11/17  18:32:16  thoth
// forward convolutions are now supported.
// template reductions are now supported.
// minimax ring products are now supported.
//
// Revision 1.1  1993/09/15  13:02:58  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:41:03  thoth
// Copyright Notices
// 
// Revision 1.1  93/05/26  17:16:30  thoth
// Initial revision
// 
// Revision 1.2  93/05/18  21:44:57  thoth
// New more descriptive names for standard convolutions.
// 
// Revision 1.1  93/03/18  11:23:20  thoth
// Initial revision
// 
// convolution linear_product zero=0 I(float) I(float) T(float)
friend IA_Image<IA_Point<int>,float> linear_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution linear_product zero=0 I(float) T(float) I(float)
friend IA_Image<IA_Point<int>,float> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution addmax_product zero=-infinity() I(float) I(float) T(float)
friend IA_Image<IA_Point<int>,float> addmax_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution addmax_product zero=-infinity() I(float) T(float) I(float)
friend IA_Image<IA_Point<int>,float> addmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution addmin_product zero=infinity() I(float) I(float) T(float)
friend IA_Image<IA_Point<int>,float> addmin_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution addmin_product zero=infinity() I(float) T(float) I(float)
friend IA_Image<IA_Point<int>,float> addmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution multmax_product zero=-infinity() I(float) I(float) T(float)
friend IA_Image<IA_Point<int>,float> multmax_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution multmax_product zero=-infinity() I(float) T(float) I(float)
friend IA_Image<IA_Point<int>,float> multmax_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
// convolution multmin_product zero=infinity() I(float) I(float) T(float)
friend IA_Image<IA_Point<int>,float> multmin_product(const IA_Image<IA_Point<int>,float> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution multmin_product zero=infinity() I(float) T(float) I(float)
friend IA_Image<IA_Point<int>,float> multmin_product(const IA_DDTemplate<IA_Image<IA_Point<int>,float> > &templ,
		const IA_Image<IA_Point<int>,float> &img,
		IA_Set<IA_Point<int> > dest_ps);

//
//
// reduction sum zero=0 I(float) T(float)
friend IA_Image<IA_Point<int>,float> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,float> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction max zero=-infinity() I(float) T(float)
friend IA_Image<IA_Point<int>,float> max(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,float> > templ,
	IA_Set<IA_Point<int> > dest_domain);

// reduction min zero=infinity() I(float) T(float)
friend IA_Image<IA_Point<int>,float> min(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,float> > templ,
	IA_Set<IA_Point<int> > dest_domain);

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: cplx-conv.desc,v $
// Revision 1.3  1994/03/30  14:00:07  thoth
// Added a template-template convolution and fixed the order of arguments
// to one of the template-image convolutions.
//
// Revision 1.2  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.1  1993/11/29  22:25:25  thoth
// Initial revision
//
// 
// convolution linear_product T(complex) T(complex) T(complex)
friend IA_DDTemplate<IA_Image<IA_Point<int>,complex> > linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &img);

// convolution linear_product zero=0.0 I(complex) I(complex) T(complex)
friend IA_Image<IA_Point<int>,complex> linear_product(const IA_Image<IA_Point<int>,complex> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

// convolution linear_product zero=0.0 I(complex) T(complex) I(complex)
friend IA_Image<IA_Point<int>,complex> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		const IA_Image<IA_Point<int>,complex> &img,
		IA_Set<IA_Point<int> > dest_ps);

// reduction sum zero=0.0 I(complex) T(complex)
friend IA_Image<IA_Point<int>,complex> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,complex> > templ,
	IA_Set<IA_Point<int> > dest_domain);

