// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FloatCI.h,v $
// Revision 1.7.1.1  1995/01/13  19:58:04  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.7  1994/12/14  16:39:08  fjsoria
// constructor in IA_Image<IA_Point<double>,float>
// looked like IA_Image<IA_Point<double>,float>
// () {...}; instead of IA_Image(){}; cfront did not
// catch this
//
// Revision 1.6  1994/09/22  16:58:30  thoth
// Added a 0-argument constructor.
//
// Revision 1.5  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1994/01/31  15:44:34  thoth
// added new constructor from float(*)(IA_Point<double>).
// added operator=(FCI).
//
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/10/20  18:58:47  thoth
// Initial revision
//

#ifndef FloatCI_h_
#define FloatCI_h_

//#include "Image.h"
#include "DblPS.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE
#if 0
class IA_Image<IA_Point<double>,float>
: public IA_Image<IA_Point<double>,float> {
public:
    IA_Image()
	:IA_Image<IA_Point<double>,float>() { }
    IA_Image(const IA_Image<IA_Point<double>,float> &fci)
	:IA_Image<IA_Point<double>,float>(fci) { }
    IA_Image(const IA_Image<IA_Point<double>,float> &fci)
	:IA_Image<IA_Point<double>,float>(fci) { }
    IA_Image(IA_Set<IA_Point<double> > ps, float value)
	:IA_Image<IA_Point<double>,float>(ps,(float)value) {}
    IA_Image(IA_Set<IA_Point<double> > ps, float *vp, unsigned sz,
	     int giveaway=0)
	:IA_Image<IA_Point<double>,float>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_Point<double>,float>& i)
	:IA_Image<IA_Point<double>,float>(i) { }

    IA_Image(IA_Set<IA_Point<double> > ps, float (*f)(const IA_Point<double>&))
	:IA_Image<IA_Point<double>,float>(ps,f) {}

    IA_Image(IA_Set<IA_Point<double> > ps, float (*f)(IA_Point<double>))
	:IA_Image<IA_Point<double>,float>(ps,f) {}

    virtual ~IA_Image(){ }

    IA_Image& operator =(const IA_Image<IA_Point<double>,float> &arg) {
	(IA_Image<IA_Point<double>,float>&)*this = arg;
	return *this;
    }
    
    IA_Image<IA_Point<double>,float>& operator=(float v) {
	float	temp=v;		// workaround CFront problem
	(IA_Image<IA_Point<double>,float>&)*this = temp;
	return *this;
    }
};
#endif

#endif
