#!/local/bin/perl

# $Id: add-templobj.perl,v 1.1 1994/09/16 18:00:39 thoth Exp thoth $

#
# $Log: add-templobj.perl,v $
# Revision 1.1  1994/09/16  18:00:39  thoth
# Initial revision
#


#  This perl script originally used an encoding file that was part of
# the archive.  Solaris couldn't stomach this.  Now it uses an external
# file.


sub do_ar {
    local(@files) = @_;


    $rval = system("ar","rv".$ar_args,$archive,
		   #	$encfile,
		   @files);
    if ($rval != 0) {
	print "$0: Failed system call:\n";
	print "    ar rv",$ar_args," $archive ",join(" ",@files),"\n";
    }
}

$encfile = "../ar-remangling";
$argsize = 4000;

$tempdir = ( (defined($ENV{TMPDIR})) ?$ENV{TMPDIR} : "/cis/tmp" )
    . "/ato$$";

system("rm","-rf",$tempdir);
( -e $tempdir ) && die "couldn't demolish temporary directory\n";
mkdir($tempdir, 0755) || die "couldn't create temporary directory\n";

$ar_args="";
while (@ARGV) {
    if ($ARGV[0] eq '-argsize') {
	# some machines have limited space to fit ARGV in
	shift;
	$argsize = shift;
    } elsif ($ARGV[0] eq '-remangling') {
	shift;
	$encfile = shift;
    } elsif ($ARGV[0] eq '-nomangle') {
	undef ($encfile);
    } elsif ($ARGV[0] =~ /^-/) {
	$ar_args = $';
	shift;
    } else {
	last;
    }
}

( $archive, @objs ) = @ARGV;

if (@objs==0) {
    print "No objects specified on command line.  Reading from stdin.\n";
    @objs=<STDIN>;
    foreach (@objs) { chop; }
}

if ( 0 && -e $encfile ) {
	print "Hey, what is the file $encfile doing around here?\n";
	print "Get it out of the way before you run $0.\n";
	exit 1;
}

if (defined( $encfile )) {
    $i=0;

# Solaris doesn\'t like archives that contain non-.o files
#$rval =system("ar","x",$archive, $encfile) /256 ;
    $rval = 0;

    if (0!=$rval || ! -e $encfile) {
	print "archive didn't have an encoding file, creating\n";
	open(ENC,">$encfile");
	close(ENC);
    } elsif ( ! -w $encfile ) {
	die "can't write to $encfile\n";
    } else {
	open(ENC,"<$encfile") || die "couldn't open $encfile for read";
	while($_=<ENC>) {
		chop;
		$MAPPING{$_} = $i;
		$i++;
	}
	close(ENC);
    }

    open(ENC,">>$encfile") || die "couldn't open $encfile for append";

    foreach (@objs) {
	( $clean = $_ ) =~ s-^.*/--;
	$num = $MAPPING{$clean};
	if ( $num eq "" ) {
	    $num = $i++;
	    $MAPPING{$clean} = $num;
	    #print "creating new mapping $clean -> $num\n";
	    print ENC $clean,"\n";
	}
	$newfilename = $tempdir."/".$num.".o";
	@files = ( @files, $newfilename );
	system("cp",$_,$newfilename);
	#print "$_ -> $newfilename\n";
    }
    close(ENC);
} else {
    @files = @objs;
}

local ($len, @temp)=(0);

for ($i=0; $i<@files; $i++) {
    if ($len + 4 + length($files[$i]) < $argsize) {
	push(@temp, $files[$i]);
	$len += 4 + length($files[$i]);
    } else {
	&do_ar(@temp);
	$len =0;
	@temp=();
	$i--;
    }
}
if (@temp) {
	&do_ar(@temp);
}

# unlink ($encfile);

system("rm", "-rf", $tempdir);
