// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: UcharDI.h,v $
// Revision 1.16.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.16.1.2  1995/01/09  17:52:46  thoth
// Outline functions shouldn't have inline qualifier.
//
// Revision 1.16.1.1  1994/12/28  18:23:57  thoth
// Image I/O is now ROF.
// Image operations are now friendly with FBI.
//
// Revision 1.16  1994/12/23  01:02:25  ljr
// Changed #include <sys/stdtypes.h> to #include "compat.h"
//
// Revision 1.15  1994/12/22  16:25:33  fjsoria
// broken type conversion
//
// Revision 1.14  1994/12/12  21:33:37  fjsoria
// IDP doesn't exsist so removed fuctions that depend
// on it.
//
// Revision 1.13  1994/12/12  21:01:01  fjsoria
// commented out ImageDisplayProtocol.h (not used)
//
// Revision 1.12  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.11  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.10  1994/03/30  13:58:31  thoth
// inline non-member functions to do image input.
//
// Revision 1.9  1994/03/14  15:51:55  thoth
// display was accepting pointer to wrong type.
//
// Revision 1.8  1994/01/31  15:50:03  thoth
// read_PGM now can return the maxval.
//
// Revision 1.7  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.6  1993/12/29  17:05:11  thoth
// Workaround for woejus CFront bug.
// write_PGM functions will no longer calculate a maxval of 0.
//
// Revision 1.5  1993/11/17  18:28:34  thoth
// write_PGM friend functions now accept Image<IntPoint, u_char> & arguments.
//
// Revision 1.4  1993/10/05  19:33:08  thoth
// Move to new Closure naming convention.
//
// Revision 1.3  1993/09/27  15:56:11  thoth
// op= with a constant now works.
//
// Revision 1.2  1993/09/24  11:37:21  jnw
// Added display function.
//
// Revision 1.1  93/09/15  12:57:32  thoth
// Initial revision
// 
// Revision 1.4  93/05/31  15:56:45  thoth
// write_PGM now supports maxval.
// 
// Revision 1.3  93/05/27  11:22:43  thoth
// Copyright Notices
// 
// Revision 1.2  93/05/18  21:41:34  thoth
// IDM interface for Uchar DIs.
// 
// Revision 1.1  93/03/18  11:17:14  thoth
// Initial revision
// 

#ifndef UcharDI_h_
#define UcharDI_h_

#include "compat.h"
//#include "Image.h"
// not used #include "ImageDisplayProtocol.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

#include	<complex.h>	// for the complex conversion
#include "Bit.h"		// for the to_bit converter function

#if 0
class IA_Image<IA_Point<int>,u_char>: public IA_Image<IA_Point<int>,u_char>
{
  public:
    IA_Image():IA_Image<IA_Point<int>,u_char>() {}

    IA_Image(const IA_Image& im)
    :IA_Image<IA_Point<int>,u_char>(im) {}

    IA_Image(IA_Set<IA_Point<int> > ps, u_char value)
    :IA_Image<IA_Point<int>,u_char>(ps,value) {}

    IA_Image(IA_Set<IA_Point<int> > ps, u_char *vp, unsigned sz,
			int giveaway=0)
    :IA_Image<IA_Point<int>,u_char>(ps, vp, sz, giveaway) {}

    IA_Image(const IA_ClosureI<IA_Point<int>,u_char> &img)
    :IA_Image<IA_Point<int>,u_char>(img) {}

    IA_Image(IA_Set<IA_Point<int> > ps, u_char (*f)(const IA_Point<int>&))
    :IA_Image<IA_Point<int>,u_char>(ps,f) {}

    IA_Image( const IA_Image<IA_Point<int>,u_char> &d)
    :IA_Image<IA_Point<int>,u_char>(d) {}

    virtual ~IA_Image(){ }

#ifdef __BROKEN_TYPE_CONVERSION
    IA_Image& operator=(u_char v) {
#else
      IA_Image& operator=(int v) {
#endif
	(IA_Image<IA_Point<int>,u_char>&)*this =  v;
	return *this;
    }

//    void IDM_display(IDP::LinkID, const char *label=0);
};
#endif

#include	"UcharIOps.h"

inline int operator!=(const IA_Image<IA_Point<int>,u_char> &lhs,
	       const IA_Image<IA_Point<int>,u_char> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_Image<IA_Point<int>,u_char> &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_Image<IA_Point<int>,u_char> &rhs) {
    return ! (rhs == lhs);
}

//
//

IA_Image<IA_Point<int>,u_char> read_uchar_PGM(istream &i,
						   int *maxval=0);
IA_Image<IA_Point<int>,u_char> read_uchar_PGM(const char *fname,
						   int *maxval=0);

//
//

ostream& write_PGM(const IA_Image<IA_Point<int>,u_char> &im,
			  ostream &o, unsigned max);

ostream& write_PGM(const IA_Image<IA_Point<int>,u_char> &im,
			  ostream &o);

void write_PGM(const IA_Image<IA_Point<int>,u_char> &im,
		      const char *fname);

void write_PGM(const IA_Image<IA_Point<int>,u_char> &im,
		      const char *fname, unsigned max);

//
//

pid_t display(IA_Image<IA_Point<int>,u_char> img);

// compiler clue to allow inexact matches on a function template
//ostream& operator <<(ostream&, const IA_Image<IA_Point<int>,u_char>&);


#endif
