// Emacs: -*- C++ -*-

//
//	Copyright 1994, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: RGBDI.h,v $
// Revision 1.4.1.3  1995/01/13  19:37:42  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.4.1.2  1995/01/09  17:52:46  thoth
// Outline functions shouldn't have inline qualifier.
//
// Revision 1.4.1.1  1994/12/28  18:04:08  thoth
// Image I/O is now ROF.
// image operations are now friendly with FBI.
//
// Revision 1.4  1994/12/23  01:05:10  ljr
// changed #include <sys/types.h> to #include "compat.h"
//
// Revision 1.3  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.2  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.1  1994/03/02  14:01:28  jnw
// Initial revision
//
// 

#ifndef RGBDI_h_
#define RGBDI_h_

#include "compat.h"
#include "IntPoint.h"
//#include "Image.h"
#include "RGB.h"

#define SUPPRESS_INCLUDE
#include "Image.h"
#undef SUPPRESS_INCLUDE

#if 0
class IA_Image<IA_Point<int>,IA_RGB>: public IA_Image<IA_Point<int>,IA_RGB>
{
  public:
    IA_Image():IA_Image<IA_Point<int>,IA_RGB>() {}

    IA_Image(const IA_Image<IA_Point<int>,IA_RGB>& im)
    :IA_Image<IA_Point<int>,IA_RGB>(im) {}

    IA_Image(IA_Set<IA_Point<int> > ps, IA_RGB value)
    :IA_Image<IA_Point<int>,IA_RGB>(ps,value) {}

    IA_Image(IA_Set<IA_Point<int> > ps, IA_RGB *vp, unsigned sz,
			int giveaway=0)
    :IA_Image<IA_Point<int>,IA_RGB>(ps, vp, sz, giveaway) {}

    IA_Image(IA_Set<IA_Point<int> > ps, const IA_RGB *vp, unsigned sz)
    :IA_Image<IA_Point<int>,IA_RGB>(ps, vp, sz) {}

    IA_Image(const IA_Point<int> *pp, unsigned plen, IA_RGB *vp, unsigned vlen,
	     int giveaway=0)
    :IA_Image<IA_Point<int>,IA_RGB>(pp, plen, vp, vlen, giveaway) {}

    IA_Image(const IA_Point<int> *pp, unsigned plen, const IA_RGB *vp,
	     unsigned vlen)
    :IA_Image<IA_Point<int>,IA_RGB>(pp, plen, vp, vlen) {}

    IA_Image(const IA_ClosureI<IA_Point<int>,IA_RGB> &img)
    :IA_Image<IA_Point<int>,IA_RGB>(img) {}

    IA_Image(IA_Set<IA_Point<int> > ps, IA_RGB (*f)(const IA_Point<int>&))
    :IA_Image<IA_Point<int>,IA_RGB>(ps,f) {}

    IA_Image( const IA_Image<IA_Point<int>,IA_RGB> &d)
    :IA_Image<IA_Point<int>,IA_RGB>(d) {}

    virtual ~IA_Image(){ }

    IA_Image& operator=(IA_RGB v) {
	(IA_Image<IA_Point<int>,IA_RGB>&)*this = v;
	return *this;
    }

};
#endif

#include	"RGBIOps.h"

inline int operator!=(const IA_Image<IA_Point<int>,IA_RGB> &lhs,
	       const IA_Image<IA_Point<int>,IA_RGB> &rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(const IA_Image<IA_Point<int>,IA_RGB> &lhs, int rhs) {
    return ! (lhs == rhs);
}
inline int operator!=(int lhs, const IA_Image<IA_Point<int>,IA_RGB> &rhs) {
    return ! (rhs == lhs);
}

//
//

ostream& write_PPM(const IA_Image<IA_Point<int>,IA_RGB> &im, ostream &o, unsigned max);

ostream& write_PPM(const IA_Image<IA_Point<int>,IA_RGB> &im, ostream &o);

void write_PPM(const IA_Image<IA_Point<int>,IA_RGB> &im, const char *fname);

void write_PPM(const IA_Image<IA_Point<int>,IA_RGB> &im,
		      const char *fname, unsigned max);

//
//

// compiler clue to allow inexact matches on a function template
ostream& operator <<(ostream&, const IA_Image<IA_Point<int>,IA_RGB>&);


#endif
