// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


// $Log: ImageIter.h,v $
// Revision 1.2.1.1  1995/01/13  19:58:04  thoth
// CoreImage has been re-merged with Image.  All special stuff should be
// friends of FBI now.
//
// Revision 1.2  1994/01/07  15:12:35  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/09/15  12:54:26  thoth
// Initial revision
//

#ifndef ImageIter_h_
#define ImageIter_h_

#ifdef IA_PRII
#pragma interface
#endif

#include "BaseImageIter.h"
#include "Image.h"

template <class P, class T>
class IA_IVIter {
protected:
    IA_BaseIVIter<P,T> *iter;
public:
    IA_IVIter();
    IA_IVIter(const IA_Image<P,T> &image)
     { iter = image.bip->value_iterator(); }

    IA_IVIter(const IA_IVIter &x) { this->iter = x.iter->clone_self(); }
    ~IA_IVIter() { delete iter; }
    
    IA_IVIter& operator=(const IA_Image<P,T> &);
    IA_IVIter& operator=(const IA_IVIter &);
    
    IA_Image<P,T> domain() { return iter->domain_(); }
    
    int operator() (T& pixel_value) {
	return this->iter->next(pixel_value);
    }

    void reset() { iter->reset(); }
};

template <class P, class T>
class IA_IPIter {
protected:
    IA_BaseIPIter<P,T> *iter;
    
public:
    IA_IPIter();
    IA_IPIter(const IA_Image<P,T> &image)
    { iter = image.bip->pixel_iterator(); }

    IA_IPIter(const IA_IPIter &x) { this->iter = x.iter->clone_self(); }
    ~IA_IPIter() { if (iter) delete iter; }
    
    IA_IPIter& operator=(const IA_Image<P,T> &);
    IA_IPIter& operator=(const IA_IPIter &);
    
    IA_Image<P,T> domain() { return iter->domain_(); }
    
    int operator() (P& pixel_location, T& pixel_value) {
	return this->iter->next(pixel_location, pixel_value);
    }
    void reset() { iter->reset(); }
};

#endif
