//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//
//
// $Log: cplx-conv.desc,v $
// Revision 1.3  1994/03/30  14:00:07  thoth
// Added a template-template convolution and fixed the order of arguments
// to one of the template-image convolutions.
//
// Revision 1.2  1994/02/12  19:36:51  thoth
// Rehack of template operation specifications.
//
// Revision 1.1  1993/11/29  22:25:25  thoth
// Initial revision
//
// 
// convolution linear_product T(complex) T(complex) T(complex)
IA_DDTemplate<IA_Image<IA_Point<int>,complex> > linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &img);

// convolution linear_product zero=0.0 I(complex) I(complex) T(complex)
IA_Image<IA_Point<int>,complex> linear_product(const IA_Image<IA_Point<int>,complex> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,complex> linear_product(const IA_Image<IA_Point<int>,complex> &img,
		const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ) {
    return linear_product(img, templ, img.domain());
}
#endif // NO_INLINE_CONVS

// convolution linear_product zero=0.0 I(complex) T(complex) I(complex)
IA_Image<IA_Point<int>,complex> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		const IA_Image<IA_Point<int>,complex> &img,
		IA_Set<IA_Point<int> > dest_ps);

#ifndef NO_INLINE_CONVS
inline IA_Image<IA_Point<int>,complex> linear_product(const IA_DDTemplate<IA_Image<IA_Point<int>,complex> > &templ,
		const IA_Image<IA_Point<int>,complex> &img) {
    return linear_product(templ, img, img.domain());
}
#endif // NO_INLINE_CONVS

// reduction sum zero=0.0 I(complex) T(complex)
IA_Image<IA_Point<int>,complex> sum(
	IA_Set<IA_Point<int> > domain,
	IA_DDTemplate<IA_Image<IA_Point<int>,complex> > templ,
	IA_Set<IA_Point<int> > dest_domain);

