// template_example.04.c
//
// Demonstrates image algebra approach to inverse smoothing of an image.
//

#include "DDTempl.h"
#include "IntConv.h"
#include "histogram.c"


int main() {
    
    IA_Image<IA_Point<int>,u_char> a, out_uchar;
    
    // read and display source image
    
    a = IA_Image< IA_Point<int>,u_char>::read_PGM(cin);

    // Here we use the closure constructor for templates.
    // Since IA_HistogramTemplate is derieved from IA_ClosureDT<I>
    //   it is a closure also.

    // The histogram template is parameterized by the image
    //   we want the histogram of, in this case image a.

    IA_DDTemplate< IA_Image<IA_Point<int>,int> >
	h( IA_HistogramTemplate< IA_Image<IA_Point<int>,u_char> >(a) );

    // Now define an image which is simply the template sum
    //   of the histogram template.  
    IA_Image<IA_Point<int>,int>
	a_histogram( sum( a.domain(),
			  h,
			  IA_boxy_pset( IA_Point<int>(min(a)),
					IA_Point<int>(max(a)) )
			  ) );

    cout << a_histogram << endl;

    return 0;
}
