// template_example.01.c

#include "DDTempl.h"
#include "UcharConv.h"


////////////////////////////////////////////////////////////////
// Binary Image Boundaries
////////////////////////////////////////////////////////////////

int main() {

// The first order of business is to create the two templates
// we need.  The 4-boundary template image is a little harder to
// create because we must create an array of Point<int>s to initialize
// the point set with.  The 8-boundary template image is easier, since
// it is rectangular.


// Create the 4-boundary template image sImage

    IA_Point<int>  sipa[5];  // Declare an array for the 5 points
    sipa[0] = IA_Point<int>( 0, 0 );
    sipa[1] = IA_Point<int>( 1, 0 );
    sipa[2] = IA_Point<int>( 0, 1 );
    sipa[3] = IA_Point<int>( 0,-1 );
    sipa[4] = IA_Point<int>(-1, 0 );

    IA_Set<IA_Point<int> >
	sips( 2,     // Dimension 2
	      sipa,  // The array of Point<int>s
	      5 );   // The number of Point<int>s.

    IA_Image<IA_Point<int>,u_char>
	sImage(sips, u_char(0) );


// Create the 8-boundary template image tImage

    IA_Set<IA_Point<int> >
	tips( IA_Point<int>(-1,-1),
	      IA_Point<int>( 1, 1) );

    IA_Image<IA_Point<int>,u_char>
	tImage(tips, u_char(0) );


// Now we can create the templates s & t

    IA_DDTemplate<IA_Image<IA_Point<int>,u_char> >
	s( 2,         // Dimension 2
	   sImage ),  // Template range image
	t( 2,
	   tImage );


// Now read in the image from standard input
    IA_Image<IA_Point<int>,u_char>
	inImage( read_uchar_PGM( cin ) );


// Force it to be binary.

    IA_Image<IA_Point<int>,u_char>
	aImage( chi_ne( inImage, (u_char) 0 ) );


// Now calculate the external boundaries and display each

    IA_Image<IA_Point<int>,u_char>
	bImage;   // the result image


// Exterior 8-boundary calculation and output
    bImage = (1 - aImage) * addmax_product(aImage, s);
    display( bImage );


// Exterior 4-boundary calculation and output
    bImage = (1 - aImage) * addmax_product(aImage, t );
    display( bImage );

    return 0;
}
