// printIPS.c      Subroutine to print int point sets.

#include "IntPS.h"
#include "PSIter.h"

typedef IA_PSIter<IA_Point<int> > IA_IPSIter;

void printIPS( const IA_Set<IA_Point<int> > & ips ) {
    IA_Point<int> ip;
    IA_IPSIter    iter(ips); // iter is an iterator over the points in ips

    cout << "{";
    for(iter(ip);;) {             // Get first point
	cout << ip;               // Print it
	if (iter(ip) == 0) break; // Check (and get) next point OR exit
	cout << ", ";             // Print comma for the new point
    }
    cout << "}";
}
