// pointset_example.03.c      IA_IntPointSet constructor examples

#include "IntPS.h"
#include "printIPS.c"


int pos_half_plane(const IA_Point<int> & p) {

    return p[0] > 0;
}


int main()
{
    IA_Set<IA_Point<int> >
	ips4( 2,	       // dimension of the points in this set
	      pos_half_plane); // pointer to predicate function
    			       // defining this set

    // ips4 contains all 2-D points whose first coordinate is > 0
    // NOTE: ips4 is *comprehensive* (its points cannot be enumerated).
    // all the other pointsets we\'ve encountered so far have been
    // *extensive* (their points can be enumerated).

    // Because ips4 is comprehensive, any attempt to print all its
    // elements should fail.

    cout << "\n*** ips4 ***\n";
    printIPS(ips4);

    return 0;
}
