// image_example.04.c   Image composition with point-to-point function

#include "UcharDI.h"
#include "FloatDI.h"
#include "FloatCI.h"
#include "BLInterp.h"

IA_Point<double>  rot30(const IA_Point<double>  &p) {
    static double theta = .523598776;
    return IA_Point<double>(p[0]*cos(theta) + p[1]*sin(theta),
			 p[1]*cos(theta) - p[0]*sin(theta));
}

int main() {
    // Declare  im1  as a byte valued image and assign its value by
    //   reading a PGM image created by image_example.01.c
    //   using the static image member.
    IA_Image<IA_Point<int>,u_char>
        im1 = read_uchar_PGM(cin);

    // Declare  im2  to be a real valued image whose value is based on
    //  an Binary Interpolation of  im1
    IA_Image<IA_Point<double>,float>
        im2 = IA_BLInterp<float>(IA_Image<IA_Point<int>,float>(im1));

    // Rotate the image 30 degrees and assign to  im2
    im2 = IA_Image<IA_Point<double>,float>( compose(im2, rot30) );

    // Create an byte valued image of the result
    IA_Image<IA_Point<int>,u_char>
	udi(to_uchar(im2.restrict(im1.domain())));

    // Display the results
    display( udi );

    return 0;
}
