// image_example.02.c      Image centroid calculation

#include "PSIter.h"
#include "IntDI.h"


int main()
{

    IA_Image<IA_Point<int>,int> a;  // Image should be binary

    a = read_int_PGM(cin);

    IA_Image<IA_Point<int>,int>
	bx(a.domain(),(int) 0 ),
	by(a.domain(), (int) 0 );

    IA_PSIter<IA_Point<int> >  psi(a.domain());


    IA_Point<int>  ip;

    // bx: image with each pixel\'s value as the point\'s 1st coordinate
    // by: image with each pixel\'s value as the point\'s 2nd coordinate
    while( psi(ip) ) {
	bx[ip] = ip[0];
	by[ip] = ip[1];
    }

    int  sa, cx1, cx2;

        sa = sum( IA_Image<IA_Point<int>,int>( chi_ne(a,(int)0) ) );

    cx1 = sum((bx*a));
    cx1 = cx1/sa;

    cx2 = sum((by*a));
    cx2 = cx2/sa;

    cout << "Image is bound by points: "
	 << a.domain().inf() << " and "
	 << a.domain().sup() << "\n"
	 << "Image centroid is at: "
	 << IA_Point<int>(cx1,cx2) << "\n";

    return 0;
}
