// image_example.01.c     Read a PGM file and display it

#include "UcharDI.h"
#include "IntDI.h"


int main() {
    IA_Image<IA_Point<int>,int>
	im1;	// im1 is an uninitialized image whose
    		// pixel values of type int

    IA_Image<IA_Point<int>,u_char> 
	im2;	// im2 is an uninitialized image whose
                // pixel values of type unsigned char

    im1 = read_int_PGM(cin);
    // im1 is initialized from the standard input stream

    cout << "Domain infimum is:  " << im1.domain().inf() << ".\n"
	 << "Domain supremum is: " << im1.domain().sup() << ".\n";

    im2 = to_uchar(im1);
    // im1 is converted to an IA_UcharDiscreteImage
    // whose value is assigned to im2

    im2 = max(im2) - im2;  // This inverts the sense of the values in im2.

    display( im2 );

    return 0;
}
