// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char rcsid[] = "$Id: VS_Specials.c,v 1.6 1994/08/22 15:10:59 thoth Exp $";

//
// $Log: VS_Specials.c,v $
// Revision 1.6  1994/08/22  15:10:59  thoth
// DOS-inspired name rework
//
// Revision 1.5  1994/07/25  16:45:35  thoth
// Name sanitization.
//
// Revision 1.4  1994/03/03  22:55:50  jnw
// Added comparator for Valueset<IA_RGB>
//
// Revision 1.3  1993/11/17  17:55:48  thoth
// Pointcmp is now pointcmp.
// Added value comparator for ValueSet<complex>
//
// Revision 1.2  1993/05/26  16:31:58  thoth
// Copyright Notices
//
// Revision 1.1  93/05/26  13:49:40  thoth
// Initial revision
// 

#include <complex.h>
#include "RGB.h"
#include "ValueSet.h"
#include "DblPoint.h"

IA_ValueSet<int> value_range(int v0, int v1) {
    IA_ValueSet<int> vs;
    int sz = v1 - v0;
    
    if (sz < 0)
	return IA_ValueSet<int>();
    if (sz == 0)
	return IA_ValueSet<int>(v0);
    int *ret_array = new int[++sz];
    for (int i = 0; i < sz; i++)
	ret_array[i] = v0+i;
    return IA_ValueSet<int>(ret_array, sz);
}

int IA_ValueSetComparator<IA_Point<double> >::value_type_compare(
    const void *t1, const void *t2) {

  return pointcmp(*(IA_Point<double> *)t1, *(IA_Point<double> *)t2);
}

int IA_ValueSetComparator<complex>::value_type_compare(
    const void *t1, const void *t2) {
    complex	*a = (complex*)t1;
    complex	*b = (complex*)t2;

    float	ap = real(*a);
    float	bp = real(*b);

    if (ap>bp)
	return 1;
    else if (ap<bp)
	return -1;

    ap = imag(*a);
    bp = imag(*b);

    if (ap>bp)
	return 1;
    else if (ap<bp)
	return -1;
    else
	return 0;
}

int IA_ValueSetComparator<IA_RGB>::value_type_compare(
    const void *t1, const void *t2) {
    IA_RGB	*a = (IA_RGB *)t1;
    IA_RGB	*b = (IA_RGB *)t2;

    if (a->red() > b->red())
	return 1;
    else if (a->red() < b->red())
	return -1;

    if (a->green() > b->green())
	return 1;
    else if (a->green() < b->green())
	return -1;

    if (a->blue() > b->blue())
	return 1;
    else if (a->blue() < b->blue())
	return -1;
    else
	return 0;
}
