// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: Set.h,v $
// Revision 1.3  1994/08/22  15:10:59  thoth
// DOS-inspired name rework
//
// Revision 1.2  1994/07/25  16:45:00  thoth
// Name sanitization.
//
// Revision 1.1  1994/03/21  23:06:36  thoth
// Initial revision
//

#ifndef IA_Set_h_
#define IA_Set_h_

#include "BaseSet.h"


template <class T> class IA_Set;

template <class T> int operator< (const IA_Set<T>&, const IA_Set<T>&);
template <class T> int operator<= (const IA_Set<T>&, const IA_Set<T>&);
template <class T> int operator== (const IA_Set<T>&, const IA_Set<T>&);

template <class T>
class IA_Set {
    IA_BaseSet<T>	*bsp;

    void set_and_reference(IA_BaseSet<T> *);
    void disassociate();

    IA_Set(IA_BaseSet<T> * s) { set_and_reference(s); }
public:
    IA_Set();
    IA_Set(const IA_Set &);

    ~IA_Set();

    IA_Set& operator= (const IA_Set&);
    
    IA_Set(T);
    IA_Set(T, T);
    IA_Set(T, T, T);
    IA_Set(T, T, T, T);
    IA_Set(T, T, T, T, T);
    IA_Set( const T*, unsigned int);

    // card: cardinality, number of elements in the set
    
    unsigned int card() const {return bsp->card();}
    
    // contains: predicate for testing membership of an element in a set
    
    int contains(T t) const { return bsp->contains(t); }
    
    // min: minimum element of the set
    
    T min() const {
	return bsp->min();
    }
    
    // max: maximum element of the set
    
    T max() const {
	return bsp->max();
    }

    // choice: some element from the set, we don't care which one
    T choice() const {
	return bsp->choice();
    }
    
    // empty: predicate for testing emptiness of a set 
    
    int empty() const {return bsp->empty();}
    
    IA_Set<T> operator|  (const IA_Set<T>&) const;
    IA_Set<T> operator&  (const IA_Set<T>&) const;
    IA_Set<T> operator/  (const IA_Set<T>&) const;
    IA_Set<T> operator^  (const IA_Set<T>&) const;
    
    IA_Set<T> operator|  (const T&) const;
    IA_Set<T> operator&  (const T&) const;
    IA_Set<T> operator/  (const T&) const;
    IA_Set<T> operator^  (const T&) const;
    
    friend IA_Set<T>	
    operator|  (const T&, const IA_Set<T>&);
    friend IA_Set<T>	
    operator&  (const T&, const IA_Set<T>&);
    friend IA_Set<T>	
    operator/  (const T&, const IA_Set<T>&);
    friend IA_Set<T>	
    operator^  (const T&, const IA_Set<T>&);
    
    // The range of return values for this compare function does not include
    // all the enumerated values.
    
    friend int operator<  (const IA_Set<T>&, const IA_Set<T>&);
    friend int operator<= (const IA_Set<T>&, const IA_Set<T>&);
    friend int operator== (const IA_Set<T>&, const IA_Set<T>&);
    friend int operator!= (const IA_Set<T>&, const IA_Set<T>&);
    friend int operator>= (const IA_Set<T>&, const IA_Set<T>&);
    friend int operator> (const IA_Set<T>&, const IA_Set<T>&);

    friend IA::LatticeRelation
    compare(const IA_Set<T>&,
	    const IA_Set<T>&);
};

//
//

template <class T> inline int operator>= (const IA_Set<T>&lhs,
				   const IA_Set<T>&rhs) {
    return rhs <= lhs ;
}
template <class T> inline int operator> (const IA_Set<T>&lhs,
				  const IA_Set<T>&rhs) {
    return rhs < lhs ;
}
template <class T> inline int operator!= (const IA_Set<T>&lhs,
				   const IA_Set<T>&rhs) {
    return !(lhs == rhs) ;
}

//
//

template <class T> inline int operator< (const T&lhs, const IA_Set<T>&rhs) {
    return IA_Set<T>(lhs) < rhs;
}
template <class T> inline int operator<= (const T&lhs, const IA_Set<T>&rhs) {
    return IA_Set<T>(lhs) <= rhs;
}
template <class T> inline int operator== (const T&lhs, const IA_Set<T>&rhs) {
    return IA_Set<T>(lhs) == rhs;
}
template <class T> inline int operator>= (const T&lhs, const IA_Set<T>&rhs) {
    return rhs <= IA_Set<T>(lhs);
}
template <class T> inline int operator> (const T&lhs, const IA_Set<T>&rhs) {
    return rhs <IA_Set<T>(lhs);
}
template <class T> inline int operator!= (const T&lhs, const IA_Set<T>&rhs) {
    return !(IA_Set<T>(lhs) == rhs);
}

//
//

template <class T> inline int operator< (const IA_Set<T>&lhs, const T&rhs) {
    return lhs < IA_Set<T>(rhs);
}
template <class T> inline int operator<= (const IA_Set<T>&lhs, const T&rhs) {
    return lhs <= IA_Set<T>(rhs);
}
template <class T> inline int operator== (const IA_Set<T>&lhs, const T&rhs) {
    return lhs == IA_Set<T>(rhs);
}
template <class T> inline int operator>= (const IA_Set<T>&lhs, const T&rhs) {
    return IA_Set<T>(rhs) <= lhs ;
}
template <class T> inline int operator> (const IA_Set<T>&lhs, const T&rhs) {
    return IA_Set<T>(rhs) < lhs ;
}
template <class T> inline int operator!= (const IA_Set<T>&lhs, const T&rhs) {
    return !(lhs == IA_Set<T>(rhs)) ;
}

//
//

#ifndef SUPPRESS_INCLUDE
#include "IntPS.h"
#include "DblPS.h"
#endif

#endif
