// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: Set.c,v $
// Revision 1.2  1994/04/26  18:08:17  thoth
// Added compare function between Sets.
//
// Revision 1.1  1994/03/21  23:06:53  thoth
// Initial revision
//

#define SUPPRESS_INCLUDE
#include "Set.h"
#include "ValueSet.h"

template <class T>
void IA_Set<T>::set_and_reference(IA_BaseSet<T> *p)
{
    bsp = p;
    p->incr_ref();
}

template <class T>
void IA_Set<T>::disassociate()
{
    if (bsp->decr_ref()<=0) {
	delete bsp;
    }
    bsp=0;
}

template <class T>
IA_Set<T>::IA_Set() {
    set_and_reference(new IA_ValueSet<T>);
}

template <class T>
IA_Set<T>::IA_Set(const IA_Set<T>& s) {
    set_and_reference(s.bsp);
}

template <class T>
IA_Set<T>::~IA_Set() {
    disassociate();
}

template <class T>
IA_Set<T> & IA_Set<T>::operator=(const IA_Set<T>& s)
{
    IA_BaseSet<T>	*temp = s.bsp;

    temp->incr_ref();

    disassociate();
    
    bsp = temp;
    return *this;
}

template <class T>
IA_Set<T>::IA_Set(T t1) {
    set_and_reference(new IA_ValueSet<T>(t1));
}

template <class T>
IA_Set<T>::IA_Set(T t1, T t2) {
    set_and_reference(new IA_ValueSet<T>(t1, t2));
}

template <class T>
IA_Set<T>::IA_Set(T t1, T t2, T t3) {
    set_and_reference(new IA_ValueSet<T>(t1, t2, t3));
}

template <class T>
IA_Set<T>::IA_Set(T t1, T t2, T t3, T t4) {
    set_and_reference(new IA_ValueSet<T>(t1, t2, t3, t4));
}

template <class T>
IA_Set<T>::IA_Set(T t1, T t2, T t3, T t4, T t5) {
    set_and_reference(new IA_ValueSet<T>(t1, t2, t3, t4, t5));
}

template <class T>
IA_Set<T>::IA_Set(const T *t, unsigned int len) {
    set_and_reference(new IA_ValueSet<T>(t, len));
}

//
//

#if 1

// comparisons go here

#define STUBBY

template <class T>
int operator<(const IA_Set<T> &lhs, const IA_Set<T> &rhs)
{
#ifdef STUBBY
    if (lhs.bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)lhs.bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return *lhs_ < *rhs_;
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
#endif
}

template <class T>
int operator<=(const IA_Set<T> &lhs, const IA_Set<T> &rhs)
{
#ifdef STUBBY
    if (lhs.bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)lhs.bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return *lhs_ <= *rhs_;
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
#endif
}

template <class T>
int operator==(const IA_Set<T> &lhs, const IA_Set<T> &rhs)
{
#ifdef STUBBY
    if (lhs.bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)lhs.bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return *lhs_ == *rhs_;
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
#endif
}
#if 0
template <class T>
int operator>=(const IA_Set<T> &lhs, const IA_Set<T> &rhs)
{
#ifdef STUBBY
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return *lhs_ >= *rhs_;
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
#endif
}

template <class T>
int operator>=(const IA_Set<T> &lhs, const IA_Set<T> &rhs)
{
#ifdef STUBBY
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return *lhs_ >= *rhs_;
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
#endif
}

template <class T>
int disjoint(const IA_Set<T> &lhs, const IA_Set<T> &rhs)
{
#ifdef STUBBY
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return disjoint(*lhs_,*rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
#endif
}
#endif

#endif

template <class T>
IA::LatticeRelation
compare(const IA_Set<T>&lhs,
	const IA_Set<T>&rhs)
{
  if (lhs.bsp->type()==IA_ValueSet<T>::s_type() &&
      rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)lhs.bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return compare(*lhs_,*rhs_);
  } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
  }
}


//
//

template <class T>
IA_Set<T> IA_Set<T>::operator| (const IA_Set<T> &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(*lhs_ | *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> IA_Set<T>::operator& (const IA_Set<T> &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(*lhs_ & *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> IA_Set<T>::operator/ (const IA_Set<T> &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(*lhs_ / *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> IA_Set<T>::operator^ (const IA_Set<T> &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type() &&
	rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(*lhs_ ^ *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

//
//

template <class T>
IA_Set<T> operator|(const T &lhs, const IA_Set<T> &rhs)
{
    if (rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(lhs | *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> operator&(const T &lhs, const IA_Set<T> &rhs)
{
    if (rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(lhs & *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> operator/(const T &lhs, const IA_Set<T> &rhs)
{
    if (rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(lhs / *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__, __LINE__);
    }
}

template <class T>
IA_Set<T> operator^(const T &lhs, const IA_Set<T> &rhs)
{
    if (rhs.bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*rhs_ = (IA_ValueSet<T>*)rhs.bsp;
	return new IA_ValueSet<T>(lhs ^ *rhs_);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

//
//

template <class T>
IA_Set<T> IA_Set<T>::operator| (const T &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	return new IA_ValueSet<T>(*lhs_ | rhs);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> IA_Set<T>::operator& (const T &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	return new IA_ValueSet<T>(*lhs_ & rhs);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> IA_Set<T>::operator/ (const T &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	return new IA_ValueSet<T>(*lhs_ / rhs);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

template <class T>
IA_Set<T> IA_Set<T>::operator^ (const T &rhs) const
{
    if (bsp->type()==IA_ValueSet<T>::s_type()) {
	IA_ValueSet<T>	*lhs_ = (IA_ValueSet<T>*)bsp;
	return new IA_ValueSet<T>(*lhs_ ^ rhs);
    } else {
	IA::not_yet_implemented(__FILE__,__LINE__);
    }
}

//
//
//

void slack() {
}
