// Emacs -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

//
// $Log: BaseSet.h,v $
// Revision 1.2  1994/04/26  18:08:17  thoth
// refcount wasn't being initialized.  Disastrous.
//
// Revision 1.1  1994/03/21  23:07:27  thoth
// Initial revision
//

#ifndef IA_BaseSet_h_
#define IA_BaseSet_h_

#include "ia.h"

template <class T>
class IA_BaseSet {
    int	refcount;
public:
    IA_BaseSet() { refcount=0; }
    virtual ~IA_BaseSet() {}

    virtual IA::Type type() const=0;

    int incr_ref() { return refcount++; }
    int decr_ref() { return --refcount; }

    virtual unsigned card() const =0;

    virtual int contains (T) const = 0;

    virtual T min() const = 0;
    virtual T max() const = 0;
    virtual T choice() const = 0;
    virtual int empty() const = 0;

};

#endif // IA_BaseSet_h_
