// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//

static char copyright[] = "Copyright 1993, Center for Computer Vision and Visualization,\nUniversity of Florida.  All rights reserved.\n";

static char rcsid[] = "$Id: PSIter.c,v 1.15 1994/08/26 15:37:08 thoth Exp $";

// 
// $Log: PSIter.c,v $
// Revision 1.15  1994/08/26  15:37:08  thoth
// DOS-inspired name rework (internal files)
//
// Revision 1.14  1993/11/17  18:06:36  thoth
// *** empty log message ***
//
// Revision 1.13  1993/08/08  13:15:51  thoth
// Parametrization of the iterator class.
//
// Revision 1.12  93/07/15  11:44:37  thoth
// new iterator virtual method from BasePS is superior to case statement.
// 
// Revision 1.11  93/05/28  15:05:27  thoth
// removed dependency on with-ia-pointset*
// 
// Revision 1.10  93/05/27  18:05:39  thoth
// eliminated dependency on internal testing file.
// 
// Revision 1.9  93/05/26  16:57:44  thoth
// Copyright Notices
// 
// Revision 1.8  93/04/29  12:50:00  thoth
// Mondo PointSets are now templatized.
// 
// Revision 1.7  93/04/16  15:50:16  thoth
// use IA_IntPoint instead of IntPoint.
// 
// Revision 1.6  93/02/12  16:25:15  thoth
// more IA_ prefixes.
// more comments.
// 
// Revision 1.5  92/12/16  14:48:06  thoth
// conversion to IA_ mostly complete
// 
// Revision 1.4  92/09/30  10:28:44  thoth
// White and Black holes are now semi-public classes, unfortunately.
// type() system now based on address of static data member.
// 
// Revision 1.3  92/09/03  13:34:10  thoth
// I unnamed unused formal parameters
// 
// Revision 1.2  92/08/26  13:43:10  thoth
// meaningful exception types.
// 
// Revision 1.1  92/08/23  13:30:08  thoth
// Initial revision
// 
// 

#include "PSIter.h"
#if 0
#include "BoxyIPSIter.h"
#include "YIPSIter.h"
#include "MondoPS.h"
#endif

#ifdef IA_PRII
#pragma implementation
#endif

template <class P>
IA_BasePSIter<P> * IA_PSIter<P>::make_iter(const IA_Set<P> & ips)
{
    return ips.ps->iterator();
}


template <class P>
IA_PSIter<P>::IA_PSIter()
{
    iter = make_iter(IA_Set<P>());
}


template <class P>
IA_PSIter<P> & IA_PSIter<P>::operator=(const IA_Set<P> &x)
{
    delete this->iter;

    this->iter = make_iter(x);

    return *this;
}

template <class P>
IA_PSIter<P> & IA_PSIter<P>::operator=(const IA_PSIter<P> &x)
{
    if (x.iter==this->iter)
	return *this;

    delete this->iter;

    this->iter = x.iter->clone_self();

    return *this;
}

template <class P>
IA_Set<P> IA_PSIter<P>::domain() const
{
    return iter->domain_();
}
