// -*- C++ -*-
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

#ifndef IA_Cell_h_
#define IA_Cell_h_

#include "ia.h"

static char IA_Cell_h_rcsid[] = "$Id: Cell.h,v 1.2 1993/05/26 17:15:00 rjj Exp $";

// $Log: Cell.h,v $
//Revision 1.2  1993/05/26  17:15:00  rjj
//Added Copyright message
//
//Revision 1.1  92/12/16  02:10:01  rjj
//Initial revision
//

template <class T>
class IA_Cell {
protected:
    IA_Cell<T>  *nextCell, *prevCell;
    
    void nullCell();

//    const  char* h_file() { return IA_Cell_h_rcsid; }
//    const  char* c_file();

public:
    T cellValue;    // NOTE: this belongs to the user of this class

    IA_Cell() {this->nullCell();}
    IA_Cell(T v) {this->nullCell();
	    this->setValue(v);}
    IA_Cell(const IA_Cell &c) {this->nullCell();
		   this->setValue(c.value());}
    
    T        value() const {return this->cellValue;}
    IA_Cell<T>* next()        {return this->nextCell;}
    IA_Cell<T>* prev()        {return this->prevCell;}
    IA_Cell<T>* unlink();
    IA_Cell<T>* skip(int);

    T     setValue(T v) {return this->cellValue = v;}
    
    IA_Cell<T>* setNext(IA_Cell<T> *theNextCell) {
	this->nextCell = theNextCell;
	return this;}
    
    IA_Cell<T>* setPrev(IA_Cell<T> *thePrevCell) {
	this->prevCell = thePrevCell;
	return this;}
};

#endif
