// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: OtherImageIter.h,v $
// Revision 1.1  1993/11/29  22:24:52  thoth
// Initial revision
//

#ifndef OtherImageIter_h_
#define OtherImageIter_h_

#include "BaseImageIter.h" 
#include "PSIter.h"

template < class P,class T>
class IA_OtherIVIter: public IA_BaseIVIter<P,T> {
  protected:
    // iterator over the domain
    IA_PSIter<P>	iter;

  public:
    IA_OtherIVIter(const IA_BaseImage<P,T> *);
    IA_OtherIVIter(const IA_OtherIVIter &);

    IA_BaseIVIter<P,T> * clone_self() { return new IA_OtherIVIter<P,T>(*this);}
    int next(T&);

    void reset() { iter.reset(); }
};


template < class P,class T>
class IA_OtherIPIter: public IA_BaseIPIter<P,T> {
  protected:
    // iterator over the domain
    IA_PSIter<P>	iter;

  public:
    IA_OtherIPIter(const IA_BaseImage<P,T> *);
    IA_OtherIPIter(const IA_OtherIPIter &);

    IA_BaseIPIter<P,T> * clone_self() { return new IA_OtherIPIter<P,T>(*this);}
    int next(P&, T&);

    void reset() { iter.reset(); }
};

#endif // OtherImageIter_h_
