// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


//
// $Log: FuncI.h,v $
// Revision 1.4  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.3  1993/12/29  16:55:02  thoth
// Added FunctionI that accepts functions with simple T type instead of
// const T&
//
// Revision 1.2  1993/11/17  18:19:12  thoth
// extensivep is now extensive.
//
// Revision 1.1  1993/09/15  12:53:05  thoth
// Initial revision
//

#ifndef FunctionRefI_h_
#define FunctionRefI_h_

#include "ia.h"
#include "BaseI.h"

template < class P,class T>
class IA_FunctionRefI: public IA_BaseImage<P,T>{
private:
    T (*func)(const P&);

    static char dummy;
public:
    IA_FunctionRefI(const IA_Set<P>& p, T (*fp)(const P&))
    : IA_BaseImage<P,T>(p){
	this->func = fp;
    }

    int extensive() const { return 0; }

    T operator ()(const P&) const;

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }

    //IA_BaseImage<P,T>* clone_self_extensively() const;

#if 0
    IA_BaseImage<IA_Point<int>,T>* restricted_to
    (const IA_Point<int>Set &ips) const;
    IA_BaseImage<P,T>* restricted_to(const IA_Set<IA_Point<double> > &ips) const
#if 1
	;
#else
	{
	    return new IA_FunctionRefI(this->domain() & ips, this->func);
	}
#endif

#endif
    ostream& print_this(ostream&) const;
};

//
//
//

template < class P,class T>
class IA_FunctionI: public IA_BaseImage<P,T>{
private:
    T (*func)(P);

    static char dummy;
public:
    IA_FunctionI(const IA_Set<P>& p, T (*fp)( P))
    : IA_BaseImage<P,T>(p){
	this->func = fp;
    }

    int extensive() const { return 0; }

    T operator ()(const P&) const;

    static IA::Type s_type() { return &dummy; }
    IA::Type type() const { return &dummy; }

    //IA_BaseImage<P,T>* clone_self_extensively() const;

#if 0
    IA_BaseImage<IA_Point<int>,T>* restricted_to
    (const IA_Point<int>Set &ips) const;
    IA_BaseImage<P,T>* restricted_to(const IA_Set<IA_Point<double> > &ips) const
#if 1
	;
#else
	{
	    return new IA_FunctionI(this->domain() & ips, this->func);
	}
#endif

#endif
    ostream& print_this(ostream&) const;
};

#endif
