// Emacs: -*- C++ -*-

//
//	Copyright 1993, Center for Computer Vision and Visualization,
//	University of Florida.  All rights reserved.
//


static char FunctionDT_rcsid[] = "$Id: FuncDT.c,v 1.4 1994/09/16 14:59:10 thoth Exp $";

//
// $Log: FuncDT.c,v $
// Revision 1.4  1994/09/16  14:59:10  thoth
// more DOS-inspired name rework.
//
// Revision 1.3  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.2  1993/11/17  18:19:32  thoth
// IPSIter is now PSIter<IntPoint>.
// extensivep is now extensive.
//
// Revision 1.1  1993/09/15  12:53:13  thoth
// Initial revision
//
// Revision 1.2  93/05/27  11:28:23  thoth
// Copyright Notices
// 
// Revision 1.1  93/04/17  19:00:27  thoth
// Initial revision
// 

#include "FuncDT.h"
#include "PSIter.h"

template <class I>
char IA_FunctionDT<I>::dummy = 0;

template <class I>
I IA_FunctionDT<I>::operator ()(const IA_Point<int>& p) const {
    //if (!this->ps.contains(p))
    //ia_throw( IA::IMAGE_DOMAIN_ERROR, __FILE__, __LINE__);
    return (*(this->func))(p);
}

template <class I>
ostream& IA_FunctionDT<I>::print_this(ostream& o) const
{
    o << "FunctionDT -";
    if (this->ps.extensive()){
	IA_PSIter<IA_Point<int> > iter(this->ps);
	IA_Point<int> p;
	
	o << "(point,value) pairs follow:\n";
	while(iter(p)) {
	    o << "(" << p << "," << (*this->func)(p) << ") ";
	}
    } else {
	o << ", Function : " << (int)(this->func) <<
	    ", PointSet : Comprehensive";
    }
    return o << "\n";
}
