// Emacs: -*- C++ -*-

//
//      Copyright 1993, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.
//


//
// $Log: BitDDTempl.h,v $
// Revision 1.4  1994/08/22  15:20:29  thoth
// DOS-inspired name rework.
//
// Revision 1.3  1994/07/25  17:26:39  thoth
// Name sanitization
//
// Revision 1.2  1994/01/07  15:10:00  thoth
// Image class is now CoreImage and named image types are
// Image<P,T>.
//
// Revision 1.1  1993/11/29  22:20:39  thoth
// Initial revision
//
// 

#ifndef BitDDTempl_h_
#define BitDDTempl_h_

#include "DDTempl.h"
#include "BitDI.h"

class IA_BitDDTemplate: public IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> > {
  public:
    IA_BitDDTemplate(unsigned dim, const IA_Image<IA_Point<int>,IA_Bit>  im)
    :IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> >(IA_WhiteHole(dim), im) { }
//    IA_BitDDTemplate(const IA_Set<IA_Point<int> > &ps, const IA_Image<IA_Point<int>,IA_Bit>  im)
//    :IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> >(ps, im) { }

    IA_BitDDTemplate(const IA_ClosureDT< IA_Image<IA_Point<int>,IA_Bit>  > &o)
    :IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> >(o) { }

//    IA_BitDDTemplate(const IA_Set<IA_Point<int> > &ps,
//                   IA_Image<IA_Point<int>,IA_Bit>  (*f)(const IA_Point<int>&))
//    :IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> >(ps, f) { }
    IA_BitDDTemplate(unsigned dim,
		     IA_Image<IA_Point<int>,IA_Bit>  (*f)(const IA_Point<int>&))
    :IA_DDTemplate<IA_Image<IA_Point<int>,IA_Bit> >(IA_WhiteHole(dim), f) { }

#include        "BitConv.h"
};

#endif
