// Emacs -*- C++ -*-

//      Copyright 1994, Center for Computer Vision and Visualization,
//      University of Florida.  All rights reserved.

// $Log: compat.h,v $
// Revision 1.6  1994/09/13  21:19:25  fjsoria
// added ansi compatibility for math.h for g++ v2.6
//
// Revision 1.5  1994/09/13  19:07:07  ljr
// changed to #define IA_NO_TEMPS_IN_CONDITIONAL_EXPRS for BC++
//
// Revision 1.4  1994/09/12  23:32:33  thoth
// screwy new symbol for g++ bug.
//
// Revision 1.3  1994/08/17  01:59:51  gmt
// Added log and id comments for RCS stuff.
//

// $Id: compat.h,v 1.6 1994/09/13 21:19:25 fjsoria Exp $

#ifndef IA_compat_h_
#define IA_compat_h_

/* first section.

   Based on what compiler you have, turn on/off various symbols to
control woejus hack workarounds.

*/
#if defined(__GNUC__) && defined(__cplusplus) && defined(sun)
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_IRINT
#endif

#ifdef __BCPLUSPLUS__
#define IA_NEED_TYPES
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_RINT
#define IA_NEED_IRINT
#define IA_NO_TEMPS_IN_CONDITIONAL_EXPRS
#endif

#ifdef __SC__
#define IA_NEED_TYPES
#define IA_NEED_AINT
#define IA_NEED_NINT
#define IA_NEED_ANINT
#define IA_NEED_RINT
#define IA_NEED_IRINT

#pragma template_access extern
#endif // __SC__

#ifdef __GNUC__
// g++ still has a few problems
#define IA_NO_AUTOINST_OF_STATIC_DATA
#endif // __GNUC__

/*
   Second section.

  Based on symbols defined in the compiler-dependent section above,
perform varios disgusting hacks to work around bustedness in various
compilers.

 */


#ifdef IA_NEED_TYPES
typedef unsigned char u_char;
#else
#include <sys/types.h>
#endif

#ifdef IA_NEED_AINT
double aint(double x);
#endif

#ifdef IA_NEED_NINT
int nint(double x);
#endif

#ifdef IA_NEED_ANINT
double anint(double x);
#endif

#ifdef IA_NEED_RINT
double rint(double x);
#endif

#ifdef IA_NEED_IRINT
int irint(double x);
#endif

#endif // IA_compat_h_
