/* Licensed under a BSD license. See license.html for license */
"use strict";

var obj = `
# Blender v2.77 (sub 0) OBJ File: ''
# www.blender.org
mtllib 2.mtl
o ggg_Text.001
v 0.034000 0.100000 0.000000
v 0.034000 0.100000 -0.007000
v 0.053311 0.100000 -0.030404
v 0.073569 0.100000 -0.054981
v 0.094516 0.100000 -0.080531
v 0.115889 0.100000 -0.106852
v 0.137429 0.100000 -0.133742
v 0.158875 0.100000 -0.161000
v 0.179967 0.100000 -0.188425
v 0.200444 0.100000 -0.215815
v 0.220047 0.100000 -0.242969
v 0.238514 0.100000 -0.269685
v 0.255585 0.100000 -0.295763
v 0.271000 0.100000 -0.321000
v 0.278667 0.100000 -0.334338
v 0.285667 0.100000 -0.346954
v 0.292000 0.100000 -0.359000
v 0.297667 0.100000 -0.370630
v 0.302667 0.100000 -0.381995
v 0.307000 0.100000 -0.393250
v 0.310667 0.100000 -0.404546
v 0.313667 0.100000 -0.416037
v 0.316000 0.100000 -0.427875
v 0.317667 0.100000 -0.440213
v 0.318667 0.100000 -0.453204
v 0.319000 0.100000 -0.467000
v 0.317977 0.100000 -0.485274
v 0.314986 0.100000 -0.502523
v 0.310141 0.100000 -0.518641
v 0.303556 0.100000 -0.533518
v 0.295345 0.100000 -0.547049
v 0.285625 0.100000 -0.559125
v 0.274509 0.100000 -0.569638
v 0.262111 0.100000 -0.578481
v 0.248547 0.100000 -0.585547
v 0.233931 0.100000 -0.590727
v 0.218377 0.100000 -0.593914
v 0.202000 0.100000 -0.595000
v 0.189727 0.100000 -0.594527
v 0.177398 0.100000 -0.593046
v 0.165000 0.100000 -0.590469
v 0.152519 0.100000 -0.586704
v 0.139940 0.100000 -0.581661
v 0.127250 0.100000 -0.575250
v 0.114435 0.100000 -0.567381
v 0.101481 0.100000 -0.557963
v 0.088375 0.100000 -0.546906
v 0.075102 0.100000 -0.534120
v 0.061648 0.100000 -0.519515
v 0.048000 0.100000 -0.503000
v 0.048000 0.100000 -0.626000
v 0.061671 0.100000 -0.636522
v 0.075204 0.100000 -0.646093
v 0.088625 0.100000 -0.654719
v 0.101963 0.100000 -0.662407
v 0.115245 0.100000 -0.669166
v 0.128500 0.100000 -0.675000
v 0.141755 0.100000 -0.679918
v 0.155037 0.100000 -0.683926
v 0.168375 0.100000 -0.687031
v 0.181796 0.100000 -0.689241
v 0.195329 0.100000 -0.690561
v 0.209000 0.100000 -0.691000
v 0.238931 0.100000 -0.689215
v 0.267116 0.100000 -0.683972
v 0.293391 0.100000 -0.675438
v 0.317593 0.100000 -0.663778
v 0.339558 0.100000 -0.649160
v 0.359125 0.100000 -0.631750
v 0.376129 0.100000 -0.611715
v 0.390407 0.100000 -0.589222
v 0.401797 0.100000 -0.564438
v 0.410134 0.100000 -0.537528
v 0.415256 0.100000 -0.508660
v 0.417000 0.100000 -0.478000
v 0.415731 0.100000 -0.450564
v 0.411852 0.100000 -0.423509
v 0.405250 0.100000 -0.396469
v 0.395815 0.100000 -0.369074
v 0.383435 0.100000 -0.340957
v 0.368000 0.100000 -0.311750
v 0.349398 0.100000 -0.281085
v 0.327519 0.100000 -0.248593
v 0.302250 0.100000 -0.213906
v 0.273481 0.100000 -0.176657
v 0.241102 0.100000 -0.136478
v 0.205000 0.100000 -0.093000
v 0.466000 0.100000 -0.093000
v 0.466000 0.100000 0.000000
v 0.034000 -0.100000 0.000000
v 0.034000 -0.100000 -0.007000
v 0.053311 -0.100000 -0.030404
v 0.073569 -0.100000 -0.054981
v 0.094516 -0.100000 -0.080531
v 0.115889 -0.100000 -0.106852
v 0.137429 -0.100000 -0.133742
v 0.158875 -0.100000 -0.161000
v 0.179967 -0.100000 -0.188425
v 0.200444 -0.100000 -0.215815
v 0.220047 -0.100000 -0.242969
v 0.238514 -0.100000 -0.269685
v 0.255585 -0.100000 -0.295763
v 0.271000 -0.100000 -0.321000
v 0.278667 -0.100000 -0.334338
v 0.285667 -0.100000 -0.346954
v 0.292000 -0.100000 -0.359000
v 0.297667 -0.100000 -0.370630
v 0.302667 -0.100000 -0.381995
v 0.307000 -0.100000 -0.393250
v 0.310667 -0.100000 -0.404546
v 0.313667 -0.100000 -0.416037
v 0.316000 -0.100000 -0.427875
v 0.317667 -0.100000 -0.440213
v 0.318667 -0.100000 -0.453204
v 0.319000 -0.100000 -0.467000
v 0.317977 -0.100000 -0.485274
v 0.314986 -0.100000 -0.502523
v 0.310141 -0.100000 -0.518641
v 0.303556 -0.100000 -0.533518
v 0.295345 -0.100000 -0.547049
v 0.285625 -0.100000 -0.559125
v 0.274509 -0.100000 -0.569638
v 0.262111 -0.100000 -0.578481
v 0.248547 -0.100000 -0.585547
v 0.233931 -0.100000 -0.590727
v 0.218377 -0.100000 -0.593914
v 0.202000 -0.100000 -0.595000
v 0.189727 -0.100000 -0.594527
v 0.177398 -0.100000 -0.593046
v 0.165000 -0.100000 -0.590469
v 0.152519 -0.100000 -0.586704
v 0.139940 -0.100000 -0.581661
v 0.127250 -0.100000 -0.575250
v 0.114435 -0.100000 -0.567381
v 0.101481 -0.100000 -0.557963
v 0.088375 -0.100000 -0.546906
v 0.075102 -0.100000 -0.534120
v 0.061648 -0.100000 -0.519515
v 0.048000 -0.100000 -0.503000
v 0.048000 -0.100000 -0.626000
v 0.061671 -0.100000 -0.636522
v 0.075204 -0.100000 -0.646093
v 0.088625 -0.100000 -0.654719
v 0.101963 -0.100000 -0.662407
v 0.115245 -0.100000 -0.669166
v 0.128500 -0.100000 -0.675000
v 0.141755 -0.100000 -0.679918
v 0.155037 -0.100000 -0.683926
v 0.168375 -0.100000 -0.687031
v 0.181796 -0.100000 -0.689241
v 0.195329 -0.100000 -0.690561
v 0.209000 -0.100000 -0.691000
v 0.238931 -0.100000 -0.689215
v 0.267116 -0.100000 -0.683972
v 0.293391 -0.100000 -0.675438
v 0.317593 -0.100000 -0.663778
v 0.339558 -0.100000 -0.649160
v 0.359125 -0.100000 -0.631750
v 0.376129 -0.100000 -0.611715
v 0.390407 -0.100000 -0.589222
v 0.401797 -0.100000 -0.564438
v 0.410134 -0.100000 -0.537528
v 0.415256 -0.100000 -0.508660
v 0.417000 -0.100000 -0.478000
v 0.415731 -0.100000 -0.450564
v 0.411852 -0.100000 -0.423509
v 0.405250 -0.100000 -0.396469
v 0.395815 -0.100000 -0.369074
v 0.383435 -0.100000 -0.340957
v 0.368000 -0.100000 -0.311750
v 0.349398 -0.100000 -0.281085
v 0.327519 -0.100000 -0.248593
v 0.302250 -0.100000 -0.213906
v 0.273481 -0.100000 -0.176657
v 0.241102 -0.100000 -0.136478
v 0.205000 -0.100000 -0.093000
v 0.466000 -0.100000 -0.093000
v 0.466000 -0.100000 0.000000
v 0.034000 -0.100000 0.000000
v 0.034000 0.100000 0.000000
v 0.034000 -0.100000 -0.007000
v 0.034000 0.100000 -0.007000
v 0.053311 -0.100000 -0.030404
v 0.053311 0.100000 -0.030404
v 0.073569 -0.100000 -0.054981
v 0.073569 0.100000 -0.054981
v 0.094516 -0.100000 -0.080531
v 0.094516 0.100000 -0.080531
v 0.115889 -0.100000 -0.106852
v 0.115889 0.100000 -0.106852
v 0.137429 -0.100000 -0.133742
v 0.137429 0.100000 -0.133742
v 0.158875 -0.100000 -0.161000
v 0.158875 0.100000 -0.161000
v 0.179967 -0.100000 -0.188425
v 0.179967 0.100000 -0.188425
v 0.200444 -0.100000 -0.215815
v 0.200444 0.100000 -0.215815
v 0.220047 -0.100000 -0.242969
v 0.220047 0.100000 -0.242969
v 0.238514 -0.100000 -0.269685
v 0.238514 0.100000 -0.269685
v 0.255585 -0.100000 -0.295763
v 0.255585 0.100000 -0.295763
v 0.271000 -0.100000 -0.321000
v 0.271000 0.100000 -0.321000
v 0.278667 -0.100000 -0.334338
v 0.278667 0.100000 -0.334338
v 0.285667 -0.100000 -0.346954
v 0.285667 0.100000 -0.346954
v 0.292000 -0.100000 -0.359000
v 0.292000 0.100000 -0.359000
v 0.297667 -0.100000 -0.370630
v 0.297667 0.100000 -0.370630
v 0.302667 -0.100000 -0.381995
v 0.302667 0.100000 -0.381995
v 0.307000 -0.100000 -0.393250
v 0.307000 0.100000 -0.393250
v 0.310667 -0.100000 -0.404546
v 0.310667 0.100000 -0.404546
v 0.313667 -0.100000 -0.416037
v 0.313667 0.100000 -0.416037
v 0.316000 -0.100000 -0.427875
v 0.316000 0.100000 -0.427875
v 0.317667 -0.100000 -0.440213
v 0.317667 0.100000 -0.440213
v 0.318667 -0.100000 -0.453204
v 0.318667 0.100000 -0.453204
v 0.319000 -0.100000 -0.467000
v 0.319000 0.100000 -0.467000
v 0.317977 -0.100000 -0.485274
v 0.317977 0.100000 -0.485274
v 0.314986 -0.100000 -0.502523
v 0.314986 0.100000 -0.502523
v 0.310141 -0.100000 -0.518641
v 0.310141 0.100000 -0.518641
v 0.303556 -0.100000 -0.533518
v 0.303556 0.100000 -0.533518
v 0.295345 -0.100000 -0.547049
v 0.295345 0.100000 -0.547049
v 0.285625 -0.100000 -0.559125
v 0.285625 0.100000 -0.559125
v 0.274509 -0.100000 -0.569638
v 0.274509 0.100000 -0.569638
v 0.262111 -0.100000 -0.578481
v 0.262111 0.100000 -0.578481
v 0.248547 -0.100000 -0.585547
v 0.248547 0.100000 -0.585547
v 0.233931 -0.100000 -0.590727
v 0.233931 0.100000 -0.590727
v 0.218377 -0.100000 -0.593914
v 0.218377 0.100000 -0.593914
v 0.202000 -0.100000 -0.595000
v 0.202000 0.100000 -0.595000
v 0.189727 -0.100000 -0.594527
v 0.189727 0.100000 -0.594527
v 0.177398 -0.100000 -0.593046
v 0.177398 0.100000 -0.593046
v 0.165000 -0.100000 -0.590469
v 0.165000 0.100000 -0.590469
v 0.152519 -0.100000 -0.586704
v 0.152519 0.100000 -0.586704
v 0.139940 -0.100000 -0.581661
v 0.139940 0.100000 -0.581661
v 0.127250 -0.100000 -0.575250
v 0.127250 0.100000 -0.575250
v 0.114435 -0.100000 -0.567381
v 0.114435 0.100000 -0.567381
v 0.101481 -0.100000 -0.557963
v 0.101481 0.100000 -0.557963
v 0.088375 -0.100000 -0.546906
v 0.088375 0.100000 -0.546906
v 0.075102 -0.100000 -0.534120
v 0.075102 0.100000 -0.534120
v 0.061648 -0.100000 -0.519515
v 0.061648 0.100000 -0.519515
v 0.048000 -0.100000 -0.503000
v 0.048000 0.100000 -0.503000
v 0.048000 -0.100000 -0.626000
v 0.048000 0.100000 -0.626000
v 0.061671 -0.100000 -0.636522
v 0.061671 0.100000 -0.636522
v 0.075204 -0.100000 -0.646093
v 0.075204 0.100000 -0.646093
v 0.088625 -0.100000 -0.654719
v 0.088625 0.100000 -0.654719
v 0.101963 -0.100000 -0.662407
v 0.101963 0.100000 -0.662407
v 0.115245 -0.100000 -0.669166
v 0.115245 0.100000 -0.669166
v 0.128500 -0.100000 -0.675000
v 0.128500 0.100000 -0.675000
v 0.141755 -0.100000 -0.679918
v 0.141755 0.100000 -0.679918
v 0.155037 -0.100000 -0.683926
v 0.155037 0.100000 -0.683926
v 0.168375 -0.100000 -0.687031
v 0.168375 0.100000 -0.687031
v 0.181796 -0.100000 -0.689241
v 0.181796 0.100000 -0.689241
v 0.195329 -0.100000 -0.690561
v 0.195329 0.100000 -0.690561
v 0.209000 -0.100000 -0.691000
v 0.209000 0.100000 -0.691000
v 0.238931 -0.100000 -0.689215
v 0.238931 0.100000 -0.689215
v 0.267116 -0.100000 -0.683972
v 0.267116 0.100000 -0.683972
v 0.293391 -0.100000 -0.675438
v 0.293391 0.100000 -0.675438
v 0.317593 -0.100000 -0.663778
v 0.317593 0.100000 -0.663778
v 0.339558 -0.100000 -0.649160
v 0.339558 0.100000 -0.649160
v 0.359125 -0.100000 -0.631750
v 0.359125 0.100000 -0.631750
v 0.376129 -0.100000 -0.611715
v 0.376129 0.100000 -0.611715
v 0.390407 -0.100000 -0.589222
v 0.390407 0.100000 -0.589222
v 0.401797 -0.100000 -0.564438
v 0.401797 0.100000 -0.564438
v 0.410134 -0.100000 -0.537528
v 0.410134 0.100000 -0.537528
v 0.415256 -0.100000 -0.508660
v 0.415256 0.100000 -0.508660
v 0.417000 -0.100000 -0.478000
v 0.417000 0.100000 -0.478000
v 0.415731 -0.100000 -0.450564
v 0.415731 0.100000 -0.450564
v 0.411852 -0.100000 -0.423509
v 0.411852 0.100000 -0.423509
v 0.405250 -0.100000 -0.396469
v 0.405250 0.100000 -0.396469
v 0.395815 -0.100000 -0.369074
v 0.395815 0.100000 -0.369074
v 0.383435 -0.100000 -0.340957
v 0.383435 0.100000 -0.340957
v 0.368000 -0.100000 -0.311750
v 0.368000 0.100000 -0.311750
v 0.349398 -0.100000 -0.281085
v 0.349398 0.100000 -0.281085
v 0.327519 -0.100000 -0.248593
v 0.327519 0.100000 -0.248593
v 0.302250 -0.100000 -0.213906
v 0.302250 0.100000 -0.213906
v 0.273481 -0.100000 -0.176657
v 0.273481 0.100000 -0.176657
v 0.241102 -0.100000 -0.136478
v 0.241102 0.100000 -0.136478
v 0.205000 -0.100000 -0.093000
v 0.205000 0.100000 -0.093000
v 0.466000 -0.100000 -0.093000
v 0.466000 0.100000 -0.093000
v 0.466000 -0.100000 0.000000
v 0.466000 0.100000 0.000000
vn 0.0000 1.0000 0.0000
vn 0.0000 -1.0000 0.0000
vn -0.7071 0.0000 0.7071
vn -0.9411 0.0000 -0.3381
vn -0.7715 0.0000 -0.6362
vn -0.7725 0.0000 -0.6350
vn -0.7748 0.0000 -0.6322
vn -0.7784 0.0000 -0.6278
vn -0.7832 0.0000 -0.6218
vn -0.7893 0.0000 -0.6140
vn -0.7968 0.0000 -0.6042
vn -0.8059 0.0000 -0.5921
vn -0.8167 0.0000 -0.5770
vn -0.8297 0.0000 -0.5582
vn -0.8451 0.0000 -0.5345
vn -0.8603 0.0000 -0.5098
vn -0.8707 0.0000 -0.4918
vn -0.8798 0.0000 -0.4753
vn -0.8921 0.0000 -0.4517
vn -0.9073 0.0000 -0.4204
vn -0.9245 0.0000 -0.3811
vn -0.9425 0.0000 -0.3341
vn -0.9597 0.0000 -0.2808
vn -0.9748 0.0000 -0.2231
vn -0.9865 0.0000 -0.1637
vn -0.9944 0.0000 -0.1053
vn -0.9987 0.0000 -0.0504
vn -0.9998 0.0000 0.0159
vn -0.9935 0.0000 0.1135
vn -0.9732 0.0000 0.2298
vn -0.9379 0.0000 0.3470
vn -0.8865 0.0000 0.4627
vn -0.8187 0.0000 0.5741
vn -0.7347 0.0000 0.6783
vn -0.6354 0.0000 0.7721
vn -0.5226 0.0000 0.8526
vn -0.3990 0.0000 0.9170
vn -0.2680 0.0000 0.9634
vn -0.1338 0.0000 0.9910
vn -0.0138 0.0000 0.9999
vn 0.0789 0.0000 0.9969
vn 0.1615 0.0000 0.9868
vn 0.2464 0.0000 0.9691
vn 0.3308 0.0000 0.9437
vn 0.4119 0.0000 0.9112
vn 0.4875 0.0000 0.8731
vn 0.5561 0.0000 0.8311
vn 0.6168 0.0000 0.7871
vn 0.6696 0.0000 0.7427
vn 0.7149 0.0000 0.6991
vn 0.7534 0.0000 0.6575
vn -0.3385 0.0000 0.9409
vn -0.8972 0.0000 -0.4416
vn -0.5938 0.0000 -0.8046
vn -0.5592 0.0000 -0.8290
vn -0.5202 0.0000 -0.8540
vn -0.4766 0.0000 -0.8791
vn -0.4283 0.0000 -0.9036
vn -0.3755 0.0000 -0.9268
vn -0.3185 0.0000 -0.9479
vn -0.2579 0.0000 -0.9662
vn -0.1947 0.0000 -0.9808
vn -0.1298 0.0000 -0.9915
vn -0.0646 0.0000 -0.9979
vn 0.0137 0.0000 -0.9999
vn 0.1214 0.0000 -0.9926
vn 0.2464 0.0000 -0.9691
vn 0.3723 0.0000 -0.9281
vn 0.4952 0.0000 -0.8688
vn 0.6109 0.0000 -0.7917
vn 0.7153 0.0000 -0.6988
vn 0.8052 0.0000 -0.5929
vn 0.8784 0.0000 -0.4778
vn 0.9339 0.0000 -0.3575
vn 0.9718 0.0000 -0.2358
vn 0.9933 0.0000 -0.1159
vn 1.0000 0.0000 -0.0053
vn 0.9955 0.0000 0.0941
vn 0.9818 0.0000 0.1898
vn 0.9595 0.0000 0.2817
vn 0.9312 0.0000 0.3646
vn 0.9002 0.0000 0.4354
vn 0.8699 0.0000 0.4931
vn 0.8425 0.0000 0.5387
vn 0.8190 0.0000 0.5738
vn 0.7999 0.0000 0.6001
vn 0.7851 0.0000 0.6194
vn 0.7740 0.0000 0.6332
vn 0.9052 0.0000 -0.4249
vn 0.7071 0.0000 -0.7071
vn 0.7071 0.0000 0.7071
usemtl None
s off
f 62//1 64//1 63//1
f 61//1 64//1 62//1
f 60//1 64//1 61//1
f 60//1 65//1 64//1
f 59//1 65//1 60//1
f 59//1 66//1 65//1
f 58//1 66//1 59//1
f 57//1 66//1 58//1
f 57//1 67//1 66//1
f 56//1 67//1 57//1
f 55//1 67//1 56//1
f 55//1 68//1 67//1
f 54//1 68//1 55//1
f 53//1 68//1 54//1
f 53//1 69//1 68//1
f 52//1 69//1 53//1
f 51//1 69//1 52//1
f 51//1 70//1 69//1
f 50//1 49//1 51//1
f 49//1 48//1 51//1
f 48//1 47//1 51//1
f 47//1 46//1 51//1
f 46//1 45//1 51//1
f 45//1 44//1 51//1
f 44//1 43//1 51//1
f 43//1 42//1 51//1
f 42//1 41//1 51//1
f 41//1 40//1 51//1
f 40//1 39//1 51//1
f 39//1 70//1 51//1
f 39//1 38//1 70//1
f 38//1 71//1 70//1
f 37//1 71//1 38//1
f 36//1 71//1 37//1
f 35//1 71//1 36//1
f 35//1 72//1 71//1
f 34//1 72//1 35//1
f 33//1 72//1 34//1
f 32//1 72//1 33//1
f 32//1 73//1 72//1
f 31//1 73//1 32//1
f 30//1 73//1 31//1
f 30//1 74//1 73//1
f 29//1 74//1 30//1
f 28//1 74//1 29//1
f 28//1 75//1 74//1
f 27//1 75//1 28//1
f 26//1 75//1 27//1
f 26//1 76//1 75//1
f 25//1 76//1 26//1
f 24//1 76//1 25//1
f 24//1 77//1 76//1
f 23//1 77//1 24//1
f 22//1 77//1 23//1
f 22//1 78//1 77//1
f 21//1 78//1 22//1
f 20//1 78//1 21//1
f 20//1 79//1 78//1
f 19//1 79//1 20//1
f 18//1 79//1 19//1
f 17//1 79//1 18//1
f 17//1 80//1 79//1
f 16//1 80//1 17//1
f 15//1 80//1 16//1
f 15//1 81//1 80//1
f 14//1 81//1 15//1
f 13//1 81//1 14//1
f 13//1 82//1 81//1
f 12//1 82//1 13//1
f 12//1 83//1 82//1
f 11//1 83//1 12//1
f 11//1 84//1 83//1
f 10//1 84//1 11//1
f 9//1 84//1 10//1
f 9//1 85//1 84//1
f 8//1 85//1 9//1
f 8//1 86//1 85//1
f 7//1 86//1 8//1
f 7//1 87//1 86//1
f 6//1 87//1 7//1
f 5//1 87//1 6//1
f 5//1 88//1 87//1
f 5//1 89//1 88//1
f 4//1 89//1 5//1
f 3//1 89//1 4//1
f 2//1 89//1 3//1
f 1//1 89//1 2//1
f 153//2 151//2 152//2
f 153//2 150//2 151//2
f 153//2 149//2 150//2
f 154//2 149//2 153//2
f 154//2 148//2 149//2
f 155//2 148//2 154//2
f 155//2 147//2 148//2
f 155//2 146//2 147//2
f 156//2 146//2 155//2
f 156//2 145//2 146//2
f 156//2 144//2 145//2
f 157//2 144//2 156//2
f 157//2 143//2 144//2
f 157//2 142//2 143//2
f 158//2 142//2 157//2
f 158//2 141//2 142//2
f 158//2 140//2 141//2
f 159//2 140//2 158//2
f 138//2 139//2 140//2
f 137//2 138//2 140//2
f 136//2 137//2 140//2
f 135//2 136//2 140//2
f 134//2 135//2 140//2
f 133//2 134//2 140//2
f 132//2 133//2 140//2
f 131//2 132//2 140//2
f 130//2 131//2 140//2
f 129//2 130//2 140//2
f 128//2 129//2 140//2
f 159//2 128//2 140//2
f 127//2 128//2 159//2
f 160//2 127//2 159//2
f 160//2 126//2 127//2
f 160//2 125//2 126//2
f 160//2 124//2 125//2
f 161//2 124//2 160//2
f 161//2 123//2 124//2
f 161//2 122//2 123//2
f 161//2 121//2 122//2
f 162//2 121//2 161//2
f 162//2 120//2 121//2
f 162//2 119//2 120//2
f 163//2 119//2 162//2
f 163//2 118//2 119//2
f 163//2 117//2 118//2
f 164//2 117//2 163//2
f 164//2 116//2 117//2
f 164//2 115//2 116//2
f 165//2 115//2 164//2
f 165//2 114//2 115//2
f 165//2 113//2 114//2
f 166//2 113//2 165//2
f 166//2 112//2 113//2
f 166//2 111//2 112//2
f 167//2 111//2 166//2
f 167//2 110//2 111//2
f 167//2 109//2 110//2
f 168//2 109//2 167//2
f 168//2 108//2 109//2
f 168//2 107//2 108//2
f 168//2 106//2 107//2
f 169//2 106//2 168//2
f 169//2 105//2 106//2
f 169//2 104//2 105//2
f 170//2 104//2 169//2
f 170//2 103//2 104//2
f 170//2 102//2 103//2
f 171//2 102//2 170//2
f 171//2 101//2 102//2
f 172//2 101//2 171//2
f 172//2 100//2 101//2
f 173//2 100//2 172//2
f 173//2 99//2 100//2
f 173//2 98//2 99//2
f 174//2 98//2 173//2
f 174//2 97//2 98//2
f 175//2 97//2 174//2
f 175//2 96//2 97//2
f 176//2 96//2 175//2
f 176//2 95//2 96//2
f 176//2 94//2 95//2
f 177//2 94//2 176//2
f 178//2 94//2 177//2
f 178//2 93//2 94//2
f 178//2 92//2 93//2
f 178//2 91//2 92//2
f 178//2 90//2 91//2
//s 1
f 180//3 182//4 181//4 179//3
f 182//4 184//5 183//5 181//4
f 184//5 186//6 185//6 183//5
f 186//6 188//7 187//7 185//6
f 188//7 190//8 189//8 187//7
f 190//8 192//9 191//9 189//8
f 192//9 194//10 193//10 191//9
f 194//10 196//11 195//11 193//10
f 196//11 198//12 197//12 195//11
f 198//12 200//13 199//13 197//12
f 200//13 202//14 201//14 199//13
f 202//14 204//15 203//15 201//14
f 204//15 206//16 205//16 203//15
f 206//16 208//17 207//17 205//16
f 208//17 210//18 209//18 207//17
f 210//18 212//19 211//19 209//18
f 212//19 214//20 213//20 211//19
f 214//20 216//21 215//21 213//20
f 216//21 218//22 217//22 215//21
f 218//22 220//23 219//23 217//22
f 220//23 222//24 221//24 219//23
f 222//24 224//25 223//25 221//24
f 224//25 226//26 225//26 223//25
f 226//26 228//27 227//27 225//26
f 228//27 230//28 229//28 227//27
f 230//28 232//29 231//29 229//28
f 232//29 234//30 233//30 231//29
f 234//30 236//31 235//31 233//30
f 236//31 238//32 237//32 235//31
f 238//32 240//33 239//33 237//32
f 240//33 242//34 241//34 239//33
f 242//34 244//35 243//35 241//34
f 244//35 246//36 245//36 243//35
f 246//36 248//37 247//37 245//36
f 248//37 250//38 249//38 247//37
f 250//38 252//39 251//39 249//38
f 252//39 254//40 253//40 251//39
f 254//40 256//41 255//41 253//40
f 256//41 258//42 257//42 255//41
f 258//42 260//43 259//43 257//42
f 260//43 262//44 261//44 259//43
f 262//44 264//45 263//45 261//44
f 264//45 266//46 265//46 263//45
f 266//46 268//47 267//47 265//46
f 268//47 270//48 269//48 267//47
f 270//48 272//49 271//49 269//48
f 272//49 274//50 273//50 271//49
f 274//50 276//51 275//51 273//50
f 276//51 278//52 277//52 275//51
f 278//52 280//53 279//53 277//52
f 280//53 282//54 281//54 279//53
f 282//54 284//55 283//55 281//54
f 284//55 286//56 285//56 283//55
f 286//56 288//57 287//57 285//56
f 288//57 290//58 289//58 287//57
f 290//58 292//59 291//59 289//58
f 292//59 294//60 293//60 291//59
f 294//60 296//61 295//61 293//60
f 296//61 298//62 297//62 295//61
f 298//62 300//63 299//63 297//62
f 300//63 302//64 301//64 299//63
f 302//64 304//65 303//65 301//64
f 304//65 306//66 305//66 303//65
f 306//66 308//67 307//67 305//66
f 308//67 310//68 309//68 307//67
f 310//68 312//69 311//69 309//68
f 312//69 314//70 313//70 311//69
f 314//70 316//71 315//71 313//70
f 316//71 318//72 317//72 315//71
f 318//72 320//73 319//73 317//72
f 320//73 322//74 321//74 319//73
f 322//74 324//75 323//75 321//74
f 324//75 326//76 325//76 323//75
f 326//76 328//77 327//77 325//76
f 328//77 330//78 329//78 327//77
f 330//78 332//79 331//79 329//78
f 332//79 334//80 333//80 331//79
f 334//80 336//81 335//81 333//80
f 336//81 338//82 337//82 335//81
f 338//82 340//83 339//83 337//82
f 340//83 342//84 341//84 339//83
f 342//84 344//85 343//85 341//84
f 344//85 346//86 345//86 343//85
f 346//86 348//87 347//87 345//86
f 348//87 350//88 349//88 347//87
f 350//88 352//89 351//89 349//88
f 352//89 354//90 353//90 351//89
f 354//90 356//91 355//91 353//90
f 356//91 180//3 179//3 355//91
`;

function getTriple(parts) {
  return [parseFloat(parts[1]), parseFloat(parts[2]), parseFloat(parts[3])];
}

var verts = [];
var normals = [];
var models = [];
var model;

function addVertex(model, ndx) {
  var ptn = ndx.split("/");
  var vertNdx = parseInt(ptn[0]) - 1;
  var normNdx = parseInt(ptn[2]) - 1;
  model.position.data.push.apply(model.position.data, verts[vertNdx]);
  model.normal.data.push.apply(model.normal.data, normals[normNdx]);
}

obj.split("\n").forEach(function(line) {
  var parts = line.split(" ");
  switch (parts[0]) {
    case 'v':
      verts.push(getTriple(parts));
      break;
    case 'vn':
      normals.push(getTriple(parts));
      break;
    case 's':
      model = {
        position: { numCompnents: 3, data: [] },
        normal: { numComponents: 3, data: [] },
      };
      models.push(model);
      break;
    case 'f':
      if (parts.length === 4) {
        addVertex(model, parts[1]);
        addVertex(model, parts[2]);
        addVertex(model, parts[3]);
      } else if (parts.length == 5) {
        addVertex(model, parts[1]);
        addVertex(model, parts[2]);
        addVertex(model, parts[3]);

        addVertex(model, parts[1]);
        addVertex(model, parts[3]);
        addVertex(model, parts[4]);
      }
      break;
  }
});

console.log(JSON.stringify(models));

