// this is a parser for n8x0 bluetooth scans and wifi. 
// usage: ./n8x0BTparser <input file> <outputfile>
// ouput fields : <Unix timestamp> <mac> <name if available. other wise NO_NAME) 
// compilation :  gcc n8x0BTparser.c -W -Wall -o n8x0BTparser


#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<time.h>

int get_month(char * mon)
{
	if(mon[0]=='J' || mon[0] =='j')
	{
		if(mon[1]=='a' || mon[1]=='A') // january
			return 0;
		if (mon[2]=='N' || mon[2]=='n')
			return 5; //june
		else
			return 6;//july
	}
	if(mon[0]=='M' || mon[0]=='m')
	{
		if(mon[2]=='r' || mon[2]=='R') // MARCH
			return 2;
		else
			return 4;   //may
	}

	if(mon[0]=='A' || mon[0]=='a')
	{
		if(mon[1]=='U' || mon[1]=='u')
			return 7; //august
		else
			return 3;//april
	}	
	if(mon[0]=='F' || mon[0]=='f')
		return 1;
	if(mon[0]=='N' || mon[0]=='n')
	        return 10;
	if(mon[0]=='S' || mon[0]=='s')
                return 8;
	if(mon[0]=='O' || mon[0]=='o')
	        return 9;
	if(mon[0]=='D' || mon[0]=='d')
                return 11;
	return -1;
}		

int main(int argc, char **argv)
{
	char line[10000],*tmp,*mac,*name,*essid,*quality,*level,*noiselevel,*tmp1,actessid[100]; 
	FILE *fin, *fout;
	struct tm t_str;
	unsigned int time_w,date=0,bluetooth=0,i=0,wifi=0;
	

	fin=fopen(argv[1],"r");
	if(!fin)
	{
		printf("Cannot open the Input file:%s",argv[1]);
		exit(-1);
	}
	fout=fopen(argv[2],"w");
	if(!fout)
	{
		printf("Cannot open the Output file:%s",argv[2]);
		exit(-1);
	}
	while(fgets(line,10000,fin))
	{
		printf("%d\n",++i);

		if(date==1)
		{
			//Thu Nov  6 21:39:39 UTC 2008
			tmp=strtok(line," ");
			tmp=strtok(NULL," ");
			if(!tmp)
				continue;	
			t_str.tm_mon=get_month(tmp);
			tmp=strtok(NULL," ");
			t_str.tm_mday = atoi(tmp);
			tmp = strtok(NULL,":");
			t_str.tm_hour=atoi(tmp);
			tmp = strtok(NULL,":");
			t_str.tm_min=atoi(tmp);
			tmp = strtok(NULL," ");
			t_str.tm_sec=atoi(tmp);
			tmp = strtok(NULL," ");
			tmp = strtok(NULL,"\n ");
			t_str.tm_year=atoi(tmp)-1900;
			time_w = mktime(&t_str);
			//printf("time stamp :%u\n",time_w);
			//time_w+=1227013140;
			date =0;

		}
		//--BlueTooth--
		//DEBUG    : Test mode enabled
		//MESSAGE  : BT Search 1.0.12 started.
		//DEBUG    : Found: BDA=00:1C:43:1B:24:A1, name=SGH-A707, class=0x5a0204, rssi=0xb0, clock=0x6E2C
		//DEBUG    : Found: BDA=00:1E:7D:E0:F9:8F, name=Mysto-G, class=0x180204, rssi=0xba, clock=0x1008
		//DEBUG    : Found: BDA=00:1E:4C:D7:CF:EC, name=AGROUP_X61, class=0x7e010c, rssi=0xaf, clock=0x21C9
		//DEBUG    : Found: BDA=00:1E:37:AE:F4:9B, name=SUNGWOOK-DELL, class=0x1c010c, rssi=0xac, clock=0x7404
		//DEBUG    : Found: BDA=00:1D:6E:D9:89:25, name=N810-1, class=0x100114, rssi=0xb0, clock=0x1070
		//DEBUG    : Not sending unecessary inquiry cancel cmd
		//DEBUG    : Not sending unecessary name request cancel cmd
		//MESSAGE  : Exiting.
	
		if(bluetooth == 1)
		{
			if (strncmp(line,"DEBUG",5)==0)
			{
				tmp=strtok(line,"=");
				mac=strtok(NULL,",");
					
				if(mac!=NULL)
				{
					tmp=strtok(NULL,"=");
					name=strtok(NULL,",=\n");
					printf("Name= |%s|\n",name);
					//name[strlen(name)-1]='\0';
					if(name[0]=='\0' || name[0]==' ')
						fprintf(fout,"%u;%s;NO_NAME\n",time_w,mac);
					else
						fprintf(fout,"%u;%s;%s\n",time_w,mac,name);

				}
			}
		}				
			
		if(wifi == 1) {
//Cell 01 - Address: 00:23:EB:27:11:F0 ESSID:"ufw" Quality:180/0Signal level:-76 dBmNoise level:-256 dBm Cell 02 - Address: 00:23:EB:27:11:F1 ESSID:"" Quality:186/0Signal level:-70 dBmNoise level:-256 dBm Cell 03 - Address: 00:23:EB:27:26:40 ESSID:"ufw" Quality:171/0Signal level:-85 dBmNoise level:-256 dBm Cell 04 - Address: 00:23:EB:AE:56:D1 ESSID:"" Quality:170/0Signal level:-86 dBmNoise level:-256 dBm Cell 05 - Address: 00:0F:66:E5:A1:B2 ESSID:"hap" Quality:171/0Signal level:-85 dBmNoise level:-256 dBm Cell 06 - Address: 00:23:EB:27:26:41 ESSID:"" Quality:173/0Signal level:-83 dBmNoise level:-256 dBm Cell 07 - Address: 00:23:EB:AE:56:D0 ESSID:"ufw" Quality:172/0Signal level:-84 dBmNoise level:-256 dBm Cell 08 - Address: 00:23:EB:AE:57:31 ESSID:"" Quality:184/0Signal level:-72 dBmNoise level:-256 dBm Cell 09 - Address: 00:23:EB:27:2B:F0 ESSID:"ufw" Quality:174/0Signal level:-82 dBmNoise level:-256 dBm Cell 10 - Address: 00:23:EB:AE:57:30 ESSID:"ufw" Quality:184/0Signal level:-72 dBmNoise level:-256 dBm Cell 11 - Address: 00:23:EB:27:2B:F1 ESSID:"" Quality:171/0Signal level:-85 dBmNoise level:-256 dBm Cell 12 - Address: 00:1E:58:2D:95:B5 ESSID:"ICTA Lab" Quality:170/0Signal level:-86 dBmNoise level:-256 dBm
			tmp = strtok(line,"e");
			while(tmp) {
				tmp = strtok(NULL," "); //ell or Cell
				if(tmp == NULL)
					break;
				//printf("\t\t%s\n",tmp);
				tmp = strtok(NULL," "); //01
				//printf("\t\t%s\n",tmp);
				tmp = strtok(NULL," "); //-
				//printf("\t\t%s\n",tmp);
				tmp = strtok(NULL," "); //Address:
				//printf("\t\t%s\n",tmp);
				mac = strtok(NULL," "); //MAC:
				tmp = strtok(NULL,":"); //ESSID:
				//printf("\t\t%s\n",tmp);
				//essid = strtok(NULL,"\""); //name:
				essid = strtok(NULL,":"); //essid with Quality tag:
				//tmp = strtok(NULL,":"); //Quality:
				//printf("\t\t%s\n",tmp);
				quality = strtok(NULL,"S"); // quality value
				tmp = strtok(NULL,":"); //Signal level:
			//	printf("\t\t%s\n",tmp);
				level = strtok(NULL," "); //signal level
				tmp = strtok(NULL,":"); //dBmNoise level:
				//printf("\t\t%s\n",tmp);
				noiselevel = strtok(NULL," "); //dBmNoise
				tmp = strtok(NULL," "); //dBm:
				//printf("\t\t%s\n",tmp);
				tmp = strtok(NULL,"e"); //C:
				//printf("----%u %s %s %s %s %s\n",time_w,mac,essid,quality,level,noiselevel);
				//printf("%s\n",essid);
				if(essid)
				{
				int i=0,j=0, stcp = 0, len = strlen(essid);
				for (i = 0 ;i <len;i++) {
					if(essid[i]=='\"' && !stcp) {
						stcp = 1;
					} else if( essid[i]=='\"' && stcp ) {
						stcp = 0;
						}
					if (stcp) {
					actessid[j++]=essid[i];
						}
					}
				actessid[j++]='\"';
				actessid[j]='\0';
				}
				if(level !=NULL)
				fprintf(fout,"%u;%s;%s;%s;\n",time_w,mac,actessid,quality);
//Cell 01 - Address: 00:23:EB:27:11:F0 ESSID:"ufw ufw" Quality:180/0Signal level:-76 dBmNoise level:-256 dBm 
			}
	
		}	
	
		if(line[0]=='-' && line[2]=='B')
                {
                        bluetooth  = 1;
			date = 0;
                        wifi  = 0;
                }
		
		if(line[0]=='-' && line[2]=='W')
                {
                        wifi  = 1;
			bluetooth = 0;
			date = 0;
                }
		if(line[0]=='-' && line[2]=='D')
		{	bluetooth = 0;
			date  = 1;
                        wifi  = 0;
		}
	}
	fclose(fout);
	fclose(fin);	
	return(0);
}
