function [] = mmbia01_disp (x_list, nx, z, z_clean, c_tps, d_tps, x_new, file_name);

save_flag = 1;
test_flag = 0;

x_marker  = 'ro'; x_size = 10;
z_marker  = 'k^'; z_size = 12;
zw_marker = 'go'; zw_size = 6;

fs = 15;

fig(4);clf; figw;
fig(5);clf; figw;

[nz, jnk] = size(z);

if test_flag
  total_cases = 1;
else
  total_cases = 9;
end;

for i=1:total_cases
  
  x_now = x_list ((sum(nx(1:i-1))+1):sum(nx(1:i)),:);
  c_now = c_tps  (:,:,i);
  d_now = d_tps  (:,:,i);

  z_new  = z;
  x_disp = [x_now; x_now(1,:)];
  z_disp = [z_new; z_new(1,:)];
  
  % [1] original points:
  % -------------------------------------------------------------------
  fig(1); clf; figw;
  cplot(x_disp,'r+',x_size); hold on;
  cplot(x_disp,'r-',1);      
  axis on; 
  str = sprintf ('Sample Point-Set %d', i);
  title (str,'fontsize',fs);

  % [2] cluster centers:
  % -------------------------------------------------------------------
  x_new_now = x_new ((nz*(i-1)+1):nz*i,:);

  fig(2); clf; figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplot (x_disp,'r+',x_size); hold on;
  cplot (x_disp,'r-',1);     hold on;
  cplot (x_new_now, 'ro', x_size);
  
  axis off;
  str = sprintf ('Estimated Cluster Center Set %d', i);
  title (str, 'fontsize',fs);

  % [3] plot the transformation:
  % -------------------------------------------------------------------
  % z_tmp = cfac(z_disp, 2);
  z_tmp  = z;
  z_warp = ctps_warp_pts (z_tmp,z,c_now,d_now);
  
  fig(3); clf; figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  quiver (z_tmp(:,1), z_tmp(:,2), ...
      (z_warp(:,1)-z_tmp(:,1)),(z_warp(:,2)-z_tmp(:,2)),...
      1.0); 
  hold on;
  cplot (x_disp,  'r-',1); hold on;
  cplot (x_new_now,'ro',3); hold on;
  h = plot (z_clean(:,1),z_clean(:,2),'k-'); 
  set (h, 'linewidth', 2, 'markersize', z_size);
  cplot (z_disp,  'k^',6); hold on;
  ctps_plot_grid (z,z,c_now,d_now); hold on;
  axis off; 
  title ('Estimated Transformation','fontsize',fs);

  if save_flag
    csave ('psc', file_name,i, [1,2,3]);
  end;
  
  % plot all:
  % -------------------------------------------------------------------
      
  fig(4); figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplot (x_now, 'r+', x_size); hold on;
  axis off; 
  title ('Mean Shape Point-Set','fontsize',fs);

  fig(5); figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplot (x_disp,'r-',3); hold on;
  axis off; 
  title ('Mean Shape Point-Set','fontsize',fs);

end;

fig(4); figw;hold on;
h = plot (z(:,1),z(:,2),'k^'); 
set (h, 'linewidth', 2, 'markersize', z_size);
axis off; 
title ('Mean Shape Point-Set','fontsize',fs);

fig(5); figw; hold on;
h = plot (z_clean(:,1),z_clean(:,2),'k-'); 
set (h, 'linewidth', 2);
axis off; 
title ('Mean Shape Point-Set','fontsize',fs);


if save_flag
  csave ('psc', file_name,1,[4,5]);
end;

