% cview_sample.m
% ------------------------------------------------------------------- 
% View the newly generated shape samples (through caMIX).
%
% Usage: [] = cview_sample (x_new, nx, z, c, d);
% ------------------------------------------------------------------- 
% Last modified: 

function [] = cview_sample (x_list, nx, x_new, z, c, d);


frac = 1;
nz = length(z);

% plot 9 samples together:
figure(1);clf; 
figure(2);clf;
figure(3);clf;

for i=1:1
  x_now = x_list ((sum(nx(1:i-1))+1):sum(nx(1:i)),:);
  x_now = cfac (x_now, frac);

  x_new_now = x_new ((nz*(i-1)+1):nz*i,:);

  fig(1); hold on;
  subplot(3,3,i);
  cplot (x_now, 'r-', 6, x_new_now, 'go',6);

  % plot order, using dif color:
  x_new_now1 = x_new_now(1:2:length(x_new_now),:);
  x_new_now2 = x_new_now(2:2:length(x_new_now),:);

  fig(2); hold on;
  subplot(3,3,i);
  cplot (x_now, 'r+', 6); hold on;
  cplot (x_new_now1, 'go',6, x_new_now2, 'g^',6);
  
  % look at the average/sample alignment:
  c_now = c (:,:,i);
  d_now = d (:,:,i);
  z_warp = ctps_warp_pts (z,z,c_now,d_now);
  
  fig(3); hold on;
  subplot(3,3,i);
  cplot (x_new_now, 'r+', 6); hold on;
  cplot (z_warp, 'yo',6);
  
end;
