% ctps_randpts.m
% ------------------------------------------------------------------------
% Generate random TPS and warp the input pts.
%
% Usage: [y,c,d] = ctps_randpts (x, beta_gamma, beta_d,disp_flag);
% Input: beta_gamma -- Gamma's range.
%        beta_d     -- d's range.
%   
% Output: y   -- warpped x with (c,d).
%         c,d -- TPS parameters.
%
% Notes:
%     c = beta_gamma * q2x * gamma; d = beta_d * d;
%     y = x * d + K * c;
% ------------------------------------------------------------------------
% Last modified: 09/30/99


function [y, c, d] = ctps_randpts (x, beta_gamma, beta_d,disp_flag);


% check input:
if nargin <= 3
  disp ('# ERROR: wrong input for ctps_randpts !'); 
  help ctps_randpts; break;
end;

% Randomly generating c,d.
% ------------------------
[n,dim] = size(x);
t = [ones(n,1), x];
M = dim+1; % for 2D.

[qx,rx] = qr(t);
q1x     = qx(:, 1:M);
q2x     = qx(:, M+1:n);

gamma = beta_gamma * randn (n-M,dim);
c     = q2x * gamma;
c     = [zeros(n,1)'; c']';

d     = beta_d * randn (dim+1, dim);
d     = [ zeros(1,dim+1); d']';
d     = eye(dim+1) + d;

% Calc. y.
% --------
[y] = ctps_warp_pts (x, x, c, d);


% Add outliers:
% -------------
% ... later.

if nargin == 3 | disp_flag == 1
  
  figure(2); clf; set(gcf, 'color', [0 0 0]);

  if (dim == 2)
    ctps_plot_grid (x, x, c,d); hold on;
    axis('equal');
    
    cplot  (x,'go',6, y,'r+',6); hold on;
    cplotg (x, y);
    
  elseif (dim == 3)
    
%    disp ('# WARNING #: ctps_randpts -- no 3D display for now.');
% keyboard
    ctps_plot_grid (x, x, c, d, 2 ,5,1); hold on;

    cplot  (x,'go',6, y,'r+',6); hold on;
    cplotg (x, y);
    view (-15,50);
    
  end;
  pause (0.01);
end;