% -------------------------------------------------------------------
% crbf_warp_img.m
% --------------------------------------------------------------
% Warp a 2D image based on a RBF.
% !!! Need inverse/backward transformation parameters. !!!
%
% Usage:  
% [img1] = crbf_warp_image (img0, z, w, sigma);
% 
% 09/25/00

function [img1] = crbf_warp_img (img0, z, w, sigma);

% check input.
if nargin ~= 4
  disp ('# ERROR #: crbf_warp_img -- wrong input !');
  help crbf_warp_img; return;
end;


% generate original grid.
% -----------------------
disp ('warping grid ...');

[rows,cols]       = size(img0);
[grid_x0,grid_y0] = meshgrid (1:cols,1:rows);
grid_x0           = cim2col(grid_x0);
grid_y0           = cim2col(grid_y0);
grid_old          = [grid_x0,grid_y0]; 

grid_new          = grid_old *0;

% warp the grid points row-by-row.
% --------------------------------
complete_percent = 0;
for it_row=1:rows
  grid_old_now = grid_old ((it_row-1)*cols+1:it_row*cols,:);
  
  [dim1, dim2] = size(z); % d     -- affine: dim > 1
                          % lamda -- par:    dim = 1.
  
  % --- [pts1] = crbf_warp_pts (pts, x, c, d) --------------------------
  if dim1 > 1
    [grid_new_now] = crbf_warp_pts (grid_old_now,z,w,sigma);
  end;

  grid_new ((it_row-1)*cols+1:it_row*cols,:) = grid_new_now; 
  
  if it_row/rows > complete_percent
    str = sprintf ('%2.0f percent complete ', it_row/rows*100); disp(str); 
    complete_percent = complete_percent + 0.1;
  end;
end;
disp ('');

% warp image.
% -----------
disp ('warpping image, interpolating ...');

grid_x1 = ccol2im(grid_new(:,1), rows, cols);
grid_y1 = ccol2im(grid_new(:,2), rows, cols);

[grid_x0,grid_y0] = meshgrid (1:cols,1:rows);
grid_x0 = double (grid_x0);
grid_y0 = double (grid_y0);

img1 = interp2 (grid_x0, grid_y0, img0, grid_x1, grid_y1);
