% cplotg.m
% ----------------------------------------------------------------
% Plot links between 2 corresponding point sets.
%
% Usage: 
% [] = cplotg (x, y);                % m = eye.
% [] = cplotg (x, y, m);             % thr = 0.
% [] = cplotg (x, y, m, threshold);
% [] = cplotg (x, y, m, threshold, color_str);
% [] = cplotg (x, y, m, threshold, color_str, marker_str);
% 
% 02/01/00

function [] = cplotg(x, y, m, threshold, color_str, marker_str);

% check input:
% ------------
if (nargin == 2)
  [n,jnk]   = size(x);
  m         = eye (n,n);
  threshold = 0;
  color_str = 'y:';
  gcolor_str = 'y';
  marker_str = ':';
  
elseif (nargin == 3)
  threshold = 0;
  color_str = 'y:';
  gcolor_str = 'y';
  marker_str = ':';
  
elseif (nargin == 4)
  color_str = 'y:';
  gcolor_str = 'y';
  marker_str = ':';

elseif (nargin == 5)
  gcolor_str = color_str;
  marker_str = ':';
  
elseif (nargin == 6)
  gcolor_str = color_str;
  ;
else
  disp ('# ERROR #: cplotg -- wrong input!');
  help cplotg; return;
end;

[n, dim] = size (x);

% Test plot method:
test_flag = 0;
if test_flag 
  [indexi, indexj] = find ( m > threshold );

  tmp1 = zeros(length(indexi)*3,3);
  tmp1 (1:3:length(indexi)*3,:)=x(indexi,:);
  tmp1 (2:3:length(indexi)*3,:)=y(indexj,:);
  tmp1 (3:3:length(indexi)*3,:)=tmp1(3:3:length(indexi)*3,:)*0+NaN;
  size(tmp1);
  
  plot3 (tmp1(:,1),tmp1(:,2),tmp1(:,3),'y:');

else

  % Use gplot: (my modified version: cgplot.m)
  if (nargin < 7)
    
    % Reformat data:
    % --------------
    xy = [x; y];
    
    [siz1, temp] = size(x);
    [siz2, temp] = size(y);
    
    [indexi, indexj] = find ( m > threshold );
    index = indexi + (indexj-1) * siz1;
    
    msp = zeros(siz1,siz2);
    msp (index) = 1;
    
    madj = [zeros(siz1), msp; 
      msp',zeros(siz2)];
    
    % Plot:
    % -----
    axis ('equal'); axis('off'); 
    cgplot (madj, xy, [gcolor_str,marker_str]);
    
    % Use my specfic plot:  
  else
    [siz1, temp] = size(x);
    [siz2, temp] = size(y);
    
    [indexi, indexj] = find ( m > threshold );
    n = length(indexi);    
    
    % Plot:
    % -----
    for i=1:n
      hold on; 
      switch (dim)
	case 2
	  tmp = [x(indexi(i),:); y(indexj(i),:)];
	  plot (tmp(:,1), tmp(:,2), ... 
	      'color', gcolor_str, 'linestyle', marker_str);
	  axis ('equal'); 
	case 3
	  tmp = [x(indexi(i),:); y(indexj(i),:)];
	  plot3 (tmp(:,1), tmp(:,2), tmp(:,3), ... 
	      'color', gcolor_str, 'linestyle', marker_str);
      end;
    end;
  end;
  
  
end;