% cplot_3d_box.m
% ------------------------------------------------------------------- 
% Plot 3D boxes.
%
% Usage: [] = cplot_3d_box (grid_pts,ns,n1,color_str,marker_str);
% ------------------------------------------------------------------- 
% Last modified: 

function [] = cplot_3d_box (grid_pts,ns,n1,color_str,marker_str);

vt = [-18,28];

test_flag = 1;
if test_flag 
  plot3 (grid_pts(:,1), grid_pts(:,2), grid_pts(:,3), ...
      'color', color_str, 'linestyle', marker_str); axis off; view(vt);
  
else
  for i=1:prod(ns);
    tmp = grid_pts((i-1)*n1+1:i*n1,:); 
    plot3 (tmp(:,1),tmp(:,2),tmp(:,3), ...
	'color', color_str, 'linestyle', marker_str); 
    axis off; hold on;
  end;
end;

