% cmean_tps_disp.m
% ------------------------------------------------------------------- 
% display SCM example.
%
% Usage: cmean_tps_disp (x_list,nx,z,c_tps,d_tps,m);
% ------------------------------------------------------------------- 
% Last modified: 

function [] = cmean_tps_disp (x_list,nx,z,c_tps,d_tps,m,z_new);

save_flag = 1;

x_marker  = 'ro'; x_size = 6;
z_marker  = 'k^'; z_size = 8;
zw_marker = 'go'; zw_size = 6;

fs = 15;

fig(5);clf; figw;
fig(6);clf; figw;

for i=1:min(length(nx),9);
  x_now = x_list ((sum(nx(1:i-1))+1):sum(nx(1:i)),:);
  c_now = c_tps  (:,:,i);
  d_now = d_tps  (:,:,i);
  m_now = m      (:,:,i);

  x_disp = [x_now; x_now(1,:)];
  z_disp = [z_new; z_new(1,:)];
  
  % original points:
  % -------------------------------------------------------------------
  
  fig(1); clf; figw;
  cplot(x_disp,'ro',x_size); hold on;
  cplot(x_disp,'r-',1);      
  axis on; 
  str = sprintf ('Point-Set %d', i);
  title (str,'fontsize',fs);

  % matching to the average:
  % -------------------------------------------------------------------
  
  fig(2); clf; figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplotg (z,x_now,m_now,1/length(x_now),'b','-');
  cplot (x_disp, 'r-',      3     );      hold on;
  cplot (z_disp, 'k-',      3     );      hold on;
  cplot (z,      z_marker, z_size); hold on;
  axis off;
  title ('Estimated Correspondence','fontsize',fs);

  fig(3); clf; figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplot (x_disp, x_marker, x_size); hold on;
  % cplot (x_disp, 'r-',      3     );      hold on;
  cplot (z,      z_marker, z_size); hold on;
  cplotg (z,x_now,m_now,1/length(x_now),'b','-');
  axis off;
  title ('Estimated Correspondence','fontsize',fs);

  % plot the transformation:
  % -------------------------------------------------------------------
  
  z_tmp = cfac(z_disp, 2);
  z_warp = ctps_warp_pts (z_tmp,z,c_now,d_now);
  % cplotg (z,x_now,m_now,1/length(x_now),'b','-');
  
  fig(4); clf; figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  quiver (z_tmp(:,1), z_tmp(:,2), ...
      (z_warp(:,1)-z_tmp(:,1)),(z_warp(:,2)-z_tmp(:,2)),...
      0.5); 
  hold on;
  cplot (x_disp, 'r-',1); hold on;
  cplot (z_disp, 'k-',3); hold on;
  ctps_plot_grid (z,z,c_now,d_now); hold on;
  axis off; 
  title ('Estimated Transformation','fontsize',fs);


  if save_flag
    csave ('psc', 'scm',i,[1,2,3,4]);
  end;
  
  % plot all:
  % -------------------------------------------------------------------
    
  fig(5); figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplot (x_disp,'r-',3); hold on;
axis off; 
title ('Average Shape','fontsize',fs);
  
  fig(6); figw;
  subplot ('position', [0.05 0.05 0.9 0.7]);
  cplot (x_now, 'ro', x_size); hold on;
axis off; 
title ('Average Point-Set','fontsize',fs);
  
end;

fig(5); figw;hold on;
h = plot (z_disp(:,1),z_disp(:,2),'k-'); 
axis off; 
title ('Average Shape','fontsize',fs);
set (h, 'linewidth', 2);

fig(6); figw;hold on;
h = plot (z(:,1),z(:,2),'k^'); 
axis off; 
title ('Average Point-Set','fontsize',fs);
set (h, 'linewidth', 2, 'markersize', z_size);

if save_flag
  csave ('psc', 'scm',1,[5,6]);
end;

