% -------------------------------------------------------------------
% cmark_pts.m
% -------------------------------------------------------------------
% Mark pts.
% 
% Usage: 
% [z] = cmark_pts ();
% [z] = cmark_pts (pts0);
% [z] = cmark_pts (img);
% 
% 01/26/00

function [z] = cmark_pts(in1);

% --- no input, just setup a window and mark pts. --------------------
if (nargin < 1) 
  x1 = 1;
  y1 = 1;
  x0 = 0;
  y0 = 0;
  
  input_type = 'none';
  img        = [];
  pts0       = [];
  
elseif (nargin == 1) 
  [rows,cols,junk] = size(in1)

  % --- 2D,3D points input. ------------------------------------------
  if cols <= 3 
    pts0 = in1;
    xs   = max(pts0(:,1)) - min(pts0(:,1));
    ys   = max(pts0(:,2)) - min(pts0(:,2));
    x1   = max(pts0 (:,1)) + xs * 0.5;
    y1   = max(pts0 (:,2)) + ys * 0.5;
    x0   = min(pts0 (:,1)) - xs * 0.5;
    y0   = min(pts0 (:,2)) - ys * 0.5;
    
    input_type = 'pts';
    img        = [];
    
  % --- image input. -------------------------------------------------
  elseif cols > 3 
    img = in1;
    y1  = rows; 
    x1  = cols;
    x0  = 1;
    y0  = 1;

    input_type = 'img';
    pts0       = [];
  end;
  
else
  disp ('# ERROR #: cmark_pts -- wrong input!');
  help cmark_pts; return;
end;

Init_display (input_type, img, pts0, x0, y0, x1, y1);
corner_size = y1 / 10;
text_shift  = y1 / 100;

% cnewline; 
disp ('**************************************************');
disp ('* cmark_pts: mark points                         *');
disp ('*                                                *');
disp ('* usage: 1. pts = cmark_pts ([pts/img]);         *');
disp ('*        2. click in upper-left corner for del.  *');
disp ('*        3. click in lower-right corner for end. *');
disp ('*                                                *');
disp ('**************************************************');


% init the point set.
z=[];
index = 1;

while index < 10000
  str = sprintf ('please input point # %d ', index);
  disp (str);

  % -------------------------------------------------------------------
  % Mark points:
  % -------------------------------------------------------------------
  tmp = ginput(1);
 
  % --- upper-left corner, erase the last input. ----------------------
  if tmp(1) <= x0+corner_size & tmp(2) <= y0+corner_size
    index = index - 1;
    str = sprintf('  Last input %d cancled', index-1); disp (str);
    plot (z(index,1),z(index,2), 'r+');  hold on; % overlay last point.
    % text (z(index,1) + text_shift, z(index,2), num2str (index),'color', 'w'); 
    hold on;
    
  % --- lower-right corner, end. --------------------------------------
  elseif tmp(1) >= x1 - corner_size & tmp(2) >= y1 - corner_size
     index = 99999;

  % --- else, record it in z. -----------------------------------------
  else
    z (index,1) = tmp(1);
    z (index,2) = tmp(2);

    % display the points clicked.
    plot (z(index,1), z(index,2), 'ro'); hold on;
    % text (z(index,1) + text_shift, z(index,2), num2str(index),'color','r'); 
    hold on;

    index = index + 1;

  end;
end;

% -------------------------------------------------------------------
% Set pointer back:
% -------------------------------------------------------------------
set (gcf,'pointer', 'arrow');







%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Init Display:
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [] = Init_display(input_type, img, pts, x0,y0,x1,y1);

corner_size = y1/5;
text_shift  = y1/100;

%keyboard

fig(1);clf; figb;


% draw the corner boxes:
corner_size = y1 / 10;
text_shift  = y1 / 100;

if (strcmp(input_type, 'none'))
  % do nothing.
elseif (strcmp(input_type, 'pts'))
  cplot (pts, 'r.', 3); hold on;
  axis('equal');
  axis([x0 x1 y0 y1]); 
elseif (strcmp(input_type, 'img'))
  imagesc (img); colormap ('gray'); hold on;
  axis ('image');
  hold on;
end;


% delete box:
tmpx = [x0,y0+corner_size; x0+corner_size, y0+corner_size; x0+corner_size,y0]; 
plot(tmpx(:,1),tmpx(:,2),'r-'); hold on;
text (x0+corner_size/5,y0+corner_size/5,'delete', 'color', 'r');

tmpx = [x1-corner_size,y1; x1-corner_size, y1-corner_size; x1,y1-corner_size];
plot(tmpx(:,1),tmpx(:,2),'r-'); hold on;
text (x1-corner_size*4/5,y1-corner_size*4/5,'end', 'color', 'r');


if (strcmp(input_type, 'pts') | strcmp(input_type, 'none'))
  axis('equal');
  axis([x0 x1 y0 y1]); 
end;
