function [Xout,Yout] = cgplot(A,xy,lc)

% Modified to handle 3D plots.
% Haili Chui 06/22/2000

% GPLOT Plot graph, as in "graph theory".
%
%   GPLOT(A,xy) plots the graph specified by A and xy. A graph, G, is
%   a set of nodes numbered from 1 to n, and a set of connections, or
%   edges, between them.  
%
%   In order to plot G, two matrices are needed. The adjacency matrix,
%   A, has a(i,j) nonzero if and only if node i is connected to node
%   j.  The coordinates array, xy, is an n-by-2 matrix with the
%   position for node i in the i-th row, xy(i,:) = [x(i) y(i)].
%   
%   GPLOT(A,xy,LineSpec) uses line type and color specified in the
%   string LineSpec. See PLOT for possibilities.
%
%   [X,Y] = GPLOT(A,xy) returns the NaN-punctuated vectors
%   X and Y without actually generating a plot. These vectors
%   can be used to generate the plot at a later time if desired.
%   
%   See also SPY, TREEPLOT.

%   John Gilbert, 1991.
%   Modified 1-21-91, LS; 2-28-92, 6-16-92 CBM.
%   Copyright (c) 1984-98 by The MathWorks, Inc.
%   $Revision: 5.8 $  $Date: 1997/11/21 23:44:26 $


lc_default = 'y:';

% check input:
if (nargin < 2)
  disp ('# ERROR: cgplot -- wrong input!'); help cgplot; break;
elseif (nargin == 3)
  lc_default = lc;
end;

[jnk,dim] = size(xy);

[i,j] = find(A);
[ignore, p] = sort(max(i,j));
i = i(p);
j = j(p);

% Create a long, NaN-separated list of line segments,
% rather than individual segments.
switch (dim)
  case 2
    X = [ xy(i,1) xy(j,1) repmat(NaN,size(i))]';
    Y = [ xy(i,2) xy(j,2) repmat(NaN,size(i))]';
    X = X(:);
    Y = Y(:);
  
  case 3
    X = [ xy(i,1) xy(j,1) repmat(NaN,size(i))]';
    Y = [ xy(i,2) xy(j,2) repmat(NaN,size(i))]';
    Z = [ xy(i,3) xy(j,3) repmat(NaN,size(i))]';
    
    X = X(:);
    Y = Y(:);
    Z = Z(:);
end;

if nargout==0,
  switch (dim)
    case 2
      plot  (X, Y, lc_default);
    case 3
      plot3 (X,Y,Z,lc_default);
  end;
else
  Xout = X;
  Yout = Y;
end
