% cfrac.m
% ------------------------------------------------------------------- 
% Take a fraction of the points out.
%
% Usage: [pts1] = cfrac (pts,frac);
% ------------------------------------------------------------------- 
% Last modified: 05/11/00

function [pts1] = cfrac (pts, frac)

if nargin < 2 | nargin > 2
  disp ('# ERROR: cfrac -- wrong input !');
  help cfrac; break;
end;

% Suppose the pts is representated by a "col" vector:
% (each row is one point).
[n,jnk] = size(pts);
pts1 = pts(1:frac:n,:);