% ------------------------------------------------------------------- 
% ccluster.m
% ------------------------------------------------------------------- 
% Clustering points (median) over grid boxes of size
% "cluster_size".
%
% Usage: 
% [clustered_pts] = ccluster (pts, cluster_size);
%                          
% pts (x,y,[z]) (col,row) format:
%
% 01/24/00

function [clustered_pts] = ccluster (pts, cluster_size);

[n, dim] = size (pts);

clustered_pts = [];
point_count   = 0;
method        = 'med';

switch (dim)
  
  case 2
    
    cell_pts      = round (pts/cluster_size) + 1;
    cell_pts_left = cell_pts;
    pts_left      = pts;
    
    % calc the average of each cell/cluster:
    while (length(cell_pts_left) >= 1)
      
      i = cell_pts_left (1,1);
      j = cell_pts_left (1,2);
      
      index = find (cell_pts_left(:,1)==i & cell_pts_left(:,2)==j);
      [count,tmp] = size(index);
      
      if count >= 1
	pts_now = pts_left(index,:);
	
	switch(method)
	  case 'avg'
	    pt_new  = sum(pts_now,1) / count;
	  case 'med'
	    pt_new   = median(pts_now,1);
	end;
	
	point_count = point_count + 1;
	clustered_pts (point_count,:) = pt_new;
	
	index1 = find (cell_pts_left(:,1)~=i | cell_pts_left(:,2)~=j);
	cell_pts_left = cell_pts_left (index1,:);
	pts_left      = pts_left      (index1,:);
	length(cell_pts_left);
      end;
    end;
    
    
    figure (2);
    clf;
    cplot_2d (pts, 'y.', 3); hold on; 
    cplot_2d (clustered_pts, 'ro', 5);
    set (gca, 'box', 'on'); pause (0.01);
    
    size(clustered_pts)
  case 3
    
    cell_pts      = round (pts/cluster_size) + 1;
    cell_pts_left = cell_pts;
    
    % calc the average of each cell/cluster:
    while (length(cell_pts_left) >= 1)
      
      i = cell_pts_left (1,1);
      j = cell_pts_left (1,2);
      k = cell_pts_left (1,3);
      
      index = find (cell_pts(:,1)==i & ...
	  cell_pts(:,2)==j & ...
	  cell_pts(:,3)==k);

      [count,tmp] = size(index);
      
      if count >= 1
	pts_now = pts(index,:);
	
	switch(method)
	  case 'avg'
	    pt_new  = sum(pts_now,1) / count;
	  case 'med'
	    pt_new   = median(pts_now,1);
	end;
	
	point_count = point_count + 1;
	clustered_pts (point_count,:) = pt_new;
	
	index1 = find (cell_pts_left(:,1)~=i | cell_pts_left(:,2)~=j |cell_pts_left(:,3)~=k);
	cell_pts_left = cell_pts_left (index1,:);
	length(cell_pts_left);
      end;
    end;
    
    figure (2);
    clf;
    % h = plot (pts(:,1), pts(:,2), 'g.'); hold on;
    cplot_3d (pts, 'y.', 3); hold on; 
    cplot_3d (clustered_pts, 'ro', 5);
    set (gca, 'box', 'on'); rotate3d; pause (0.01);

    size(clustered_pts)
  otherwise
    disp ('# ERROR #: ccluster_power -- dim ~= 2 or 3 !!!');
end;







