% cMIX_plot_mixture.m
% ------------------------------------------------------------------- 
% Plot the clusters as bunch of ecllipses.
%
% Usage: 
% ------------------------------------------------------------------- 
% Last modified: 

function [] = cMIX_plot_mixture (vx, Cx);

[c,tmp] = size (vx);
% if c==2; c=1;end;

for i=1:c
  
  % Solve ecllips parameters from Cx:
  % ---------------------------------
  I = Cx(:,:,i);
  [vec, val] = eig (I);
  tan_val = vec(2,1) / vec(1,1);
  if abs(val(2,2)) > abs(val(1,1))
    tan_val = - (1/tan_val);
  end;
  theta = atan (tan_val);
  
  R = [cos(theta), -sin(theta); sin(theta), cos(theta)];
  Cx_ortho = R' * Cx (:,:,i) * R;
  
  a = sqrt(2*Cx_ortho(1,1));
  b = sqrt(2*Cx_ortho(2,2));
  
  % Generate the ecllips:
  % ---------------------
  tmp_theta = [1:10:360]'/260*2*pi;
  tmp_pts   = [a*cos(tmp_theta), b*sin(tmp_theta)];
  tmp_pts   = tmp_pts * R';
  
  % Draw the ecllips:
  % -----------------
  plot (tmp_pts(:,1) + vx(i,1), tmp_pts(:,2)+vx(i,2), 'b-'); hold on;
end;
