% 
% ------------------------------------------------------------------- 
%
%
% Usage: 
% ------------------------------------------------------------------- 
% Last modified: 

function [y,x] = test_3d ();

method = 2;
switch (method)
  
  case 1
    n = 50;
    phi = [0:(600-0)/(n-1):600]'/180*pi;
    theta = [0:(70-0)/(n-1):70]'/180*pi;
    
    x = [cos(theta).*cos(phi), cos(theta).*sin(phi), sin(theta)];
    y = ctps_randpts(x,0.15,0.15,'on');

  case 2
    nnow  = 2;
    tmax = 60; theta = [-tmax:tmax/nnow:tmax]'/180*pi;
    
    x = [];
    for i=1:length(theta);
      t1   = theta(i);
      
      nnow = abs(90/180*pi-abs(t1))/max(theta) * 50;
      phi  = [0:360/nnow:360]'/180*pi;

      xnow = [cos(t1).*cos(phi), cos(t1).*sin(phi), sin(t1).*repmat(1,size(phi))];
      x = [x; xnow];
    end;
    % y = ctps_randpts(x,0.15,0.15,'on');
    y = x;
end;
